/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import untamedwilds.block.blockentity.ReptileNestBlockEntity;
import untamedwilds.config.ConfigMobControl;

public class NestReptileBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.5, (double)15.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public NestReptileBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return this.isValidGround(worldIn.m_8055_(blockpos), (BlockGetter)worldIn, blockpos);
    }

    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return !state.m_60812_(worldIn, pos).m_83263_(Direction.UP).m_83281_();
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (!this.m_7898_(stateIn, (LevelReader)worldIn, currentPos)) {
            worldIn.m_46961_(currentPos, false);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ReptileNestBlockEntity(pos, state);
    }

    public void m_142072_(Level levelIn, BlockState stateIn, BlockPos posIn, Entity entityIn, float p_154849_) {
        ReptileNestBlockEntity te = (ReptileNestBlockEntity)levelIn.m_7702_(posIn);
        if (te != null && !entityIn.m_6095_().equals(te.getEntityType())) {
            te.trampleOnNest(levelIn, posIn, stateIn);
        }
        super.m_142072_(levelIn, stateIn, posIn, entityIn, p_154849_);
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        if (((Boolean)ConfigMobControl.tickingNests.get()).booleanValue() && (blockEntity = worldIn.m_7702_(pos)) instanceof ReptileNestBlockEntity) {
            ReptileNestBlockEntity burrow = (ReptileNestBlockEntity)blockEntity;
            burrow.createMobs(worldIn);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (worldIn.f_46443_ || hand.equals((Object)InteractionHand.OFF_HAND)) {
            return InteractionResult.FAIL;
        }
        ReptileNestBlockEntity te = (ReptileNestBlockEntity)worldIn.m_7702_(pos);
        if (te != null) {
            te.removeEggs(worldIn, 1);
            CompoundTag baseTag = new CompoundTag();
            ItemStack item = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("untamedwilds:egg_" + te.getEntityType().m_204041_().m_205785_().m_135782_().m_135815_())));
            baseTag.m_128405_("variant", te.getVariant());
            baseTag.m_128405_("custom_model_data", te.getVariant());
            item.m_41751_(baseTag);
            playerIn.m_150109_().m_36054_(item);
        }
        return InteractionResult.SUCCESS;
    }
}

