/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import untamedwilds.block.blockentity.CageBlockEntity;
import untamedwilds.init.ModBlock;
import untamedwilds.util.EntityUtils;

public class CageBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape CAGE_COLLISION_AABB_EMPTY = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final VoxelShape CAGE_COLLISION_AABB_FULL = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public CageBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)OPEN, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{OPEN, WATERLOGGED});
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        this.m_142387_(worldIn, player, pos, state);
        if (!worldIn.f_46443_) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof CageBlockEntity) {
                CageBlockEntity te = (CageBlockEntity)tileentity;
                ItemStack itemstack = new ItemStack((ItemLike)ModBlock.TRAP_CAGE.get());
                CompoundTag compound = new CompoundTag();
                if (te.hasTagCompound() && te.isLocked()) {
                    compound.m_128379_("closed", te.isLocked());
                    compound.m_128365_("EntityTag", (Tag)te.getTagCompound().m_128469_("EntityTag"));
                    itemstack.m_41751_(compound);
                }
                CageBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)itemstack);
                worldIn.m_46717_(pos, state.m_60734_());
            } else {
                super.m_5707_(worldIn, pos, state, player);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)OPEN) != false ? CAGE_COLLISION_AABB_EMPTY : CAGE_COLLISION_AABB_FULL;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)blockstate.m_61124_((Property)OPEN, (Comparable)Boolean.TRUE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (stack.m_41782_()) {
            BlockEntity te = worldIn.m_7702_(pos);
            if (stack.m_41783_() != null && te instanceof CageBlockEntity) {
                CageBlockEntity blockEntity = (CageBlockEntity)te;
                te.m_142466_(stack.m_41783_());
                if (blockEntity.isLocked() && blockEntity.hasTagCompound()) {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.FALSE));
                }
            }
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_ && worldIn.m_46753_(pos)) {
            this.trySpawningEntity(state, (ServerLevel)worldIn, pos);
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (playerIn.m_20161_() || worldIn.f_46443_ || ((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        boolean success = this.trySpawningEntity(state, (ServerLevel)worldIn, pos);
        return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    private boolean trySpawningEntity(BlockState state, ServerLevel worldIn, BlockPos pos) {
        CageBlockEntity te = (CageBlockEntity)worldIn.m_7702_(pos);
        BlockPos check = pos.m_7495_();
        if (te != null) {
            BlockPos spawnpos = new BlockPos((double)pos.m_123341_(), (double)((float)pos.m_123342_() + 1.0f), (double)pos.m_123343_());
            if (te.spawnCagedCreature(worldIn, spawnpos, worldIn.m_46859_(check))) {
                this.spawnParticles((Level)worldIn, pos, ParticleTypes.f_123759_);
                worldIn.m_5594_(null, pos, SoundEvents.f_12637_, SoundSource.BLOCKS, 0.3f, 0.8f);
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.TRUE));
                return true;
            }
            this.spawnParticles((Level)worldIn, pos, ParticleTypes.f_123762_);
            worldIn.m_5594_(null, pos, SoundEvents.f_12636_, SoundSource.BLOCKS, 0.3f, 0.6f);
        }
        return false;
    }

    private <T extends ParticleOptions> void spawnParticles(Level worldIn, BlockPos pos, T particle) {
        RandomSource random = worldIn.m_213780_();
        float d3 = random.m_188501_() * 0.02f;
        float d1 = random.m_188501_() * 0.02f;
        float d2 = random.m_188501_() * 0.02f;
        ((ServerLevel)worldIn).m_8767_(particle, (double)((float)pos.m_123341_() + random.m_188501_()), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + random.m_188501_()), 15, (double)d3, (double)d1, (double)d2, (double)0.12f);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        CageBlockEntity te = (CageBlockEntity)world.m_7702_(pos);
        if (!world.f_46443_ && !(entity instanceof Player) && entity.m_6084_() && entity instanceof LivingEntity && te != null && !te.isLocked() && entity instanceof Mob && te.cageEntity((Mob)entity)) {
            world.m_5594_(null, pos, SoundEvents.f_12637_, SoundSource.BLOCKS, 0.3f, 0.8f);
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.FALSE));
            this.spawnParticles(world, pos, ParticleTypes.f_123759_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41783_() != null) {
            EntityType<?> type = EntityUtils.getEntityTypeFromTag(stack.m_41783_(), null);
            if (type != null) {
                EntityUtils.buildTooltipData(stack, tooltip, type, EntityUtils.getVariantName(type, stack.m_41783_().m_128469_("EntityTag").m_128451_("Variant")));
            }
        } else {
            tooltip.add((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("block.trap_cage.state_empty")).m_130940_(ChatFormatting.GRAY));
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CageBlockEntity(pos, state);
    }

    public static class DispenserBehaviorTrapCage
    implements DispenseItemBehavior {
        public ItemStack m_6115_(BlockSource source, ItemStack stack) {
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos blockpos = source.m_7961_().m_121945_(direction);
                Direction direction1 = source.m_7727_().m_46859_(blockpos.m_7495_()) ? direction : Direction.UP;
                boolean bl = ((BlockItem)item).m_40576_((BlockPlaceContext)new DirectionalPlaceContext((Level)source.m_7727_(), blockpos, direction, stack, direction1)) == InteractionResult.SUCCESS;
            }
            return stack;
        }

        protected void playDispenseSound(BlockSource source) {
            source.m_7727_().m_6798_(1000, source.m_7961_(), 0);
        }
    }
}

