/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.world;

import com.github.wolfiewaffle.hardcore_torches.blockentity.LanternBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockInit;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ReplaceAllFeature
extends Feature<NoneFeatureConfiguration> {
    private static Map<BlockState, BlockState> REPLACEMENTS = new HashMap<BlockState, BlockState>();
    private static BlockState TORCH_STATE = Blocks.f_50081_.m_49966_();
    private static BlockState TORCH_STATE_EAST = (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.EAST);
    private static BlockState TORCH_STATE_NORTH = (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH);
    private static BlockState TORCH_STATE_SOUTH = (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.SOUTH);
    private static BlockState TORCH_STATE_WEST = (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.WEST);
    private static BlockState LANTERN_STATE = Blocks.f_50681_.m_49966_();
    private static BlockState LANTERN_STATE_HANGING = (BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true));

    public ReplaceAllFeature(Codec codec) {
        super(codec);
    }

    public boolean place(NoneFeatureConfiguration p_204741_, WorldGenLevel p_204742_, ChunkGenerator p_204743_, RandomSource p_204744_, BlockPos p_204745_) {
        return super.m_225028_((FeatureConfiguration)p_204741_, p_204742_, p_204743_, p_204744_, p_204745_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        if (!((Boolean)Config.lanternsUseFuel.get()).booleanValue()) {
            return true;
        }
        BlockPos origin = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        ChunkAccess chunk = level.m_46865_(origin);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < chunk.m_141928_(); ++y) {
                    BlockPos pos = new BlockPos(origin.m_123341_() + x, origin.m_123342_() + y, origin.m_123343_() + z);
                    BlockState oldState = chunk.m_8055_(pos);
                    BlockState newState = REPLACEMENTS.get(oldState);
                    if (newState == null) continue;
                    chunk.m_6978_(pos, newState, false);
                    Block newBlock = newState.m_60734_();
                    if (!(newBlock instanceof BaseEntityBlock)) continue;
                    BlockEntity newEntity = ((BaseEntityBlock)chunk.m_8055_(pos).m_60734_()).m_142194_(pos, newState);
                    chunk.m_142169_(newEntity);
                    if (newEntity instanceof LanternBlockEntity) {
                        ((LanternBlockEntity)newEntity).setFuel((Integer)Config.defaultLanternFuel.get());
                    }
                    newEntity.m_6596_();
                }
            }
        }
        return true;
    }

    static {
        REPLACEMENTS.put(TORCH_STATE, ((Block)BlockInit.LIT_TORCH.get()).m_49966_());
        REPLACEMENTS.put(TORCH_STATE_EAST, ((Block)BlockInit.LIT_WALL_TORCH.get()).m_152465_(TORCH_STATE_EAST));
        REPLACEMENTS.put(TORCH_STATE_NORTH, ((Block)BlockInit.LIT_WALL_TORCH.get()).m_152465_(TORCH_STATE_NORTH));
        REPLACEMENTS.put(TORCH_STATE_SOUTH, ((Block)BlockInit.LIT_WALL_TORCH.get()).m_152465_(TORCH_STATE_SOUTH));
        REPLACEMENTS.put(TORCH_STATE_WEST, ((Block)BlockInit.LIT_WALL_TORCH.get()).m_152465_(TORCH_STATE_WEST));
        REPLACEMENTS.put(LANTERN_STATE, ((Block)BlockInit.LIT_LANTERN.get()).m_49966_());
        REPLACEMENTS.put(LANTERN_STATE_HANGING, ((Block)BlockInit.LIT_LANTERN.get()).m_152465_(LANTERN_STATE_HANGING));
    }
}

