/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.loot;

import com.github.wolfiewaffle.hardcore_torches.MainMod;
import com.github.wolfiewaffle.hardcore_torches.block.AbstractHardcoreTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class TorchLootFunction
extends LootItemConditionalFunction {
    public TorchLootFunction(LootItemCondition[] lootConditions) {
        super(lootConditions);
    }

    public LootItemFunctionType m_7162_() {
        return MainMod.HARDCORE_TORCH_LOOT_FUNCTION;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        BlockEntity blockEntity = (BlockEntity)context.m_165124_(LootContextParams.f_81462_);
        BlockState state = (BlockState)context.m_165124_(LootContextParams.f_81461_);
        ItemStack itemStack = new ItemStack((ItemLike)state.m_60734_().m_5456_());
        if (state.m_60734_() instanceof AbstractHardcoreTorchBlock) {
            ETorchState torchState;
            ETorchState dropTorchState = torchState = ((AbstractHardcoreTorchBlock)state.m_60734_()).burnState;
            if (((Boolean)Config.torchesBurnWhenDropped.get()).booleanValue()) {
                if (dropTorchState != ETorchState.BURNT) {
                    dropTorchState = ETorchState.BURNT;
                }
            } else if (((Boolean)Config.torchesExtinguishWhenBroken.get()).booleanValue() && dropTorchState != ETorchState.BURNT) {
                dropTorchState = ETorchState.UNLIT;
            }
            if (dropTorchState == ETorchState.SMOLDERING) {
                dropTorchState = ETorchState.UNLIT;
            }
            itemStack = (Boolean)Config.burntStick.get() != false && dropTorchState == ETorchState.BURNT ? new ItemStack((ItemLike)Items.f_42398_) : this.getChangedStack(state, dropTorchState);
        }
        return itemStack;
    }

    private ItemStack getChangedStack(BlockState state, ETorchState torchState) {
        return new ItemStack((ItemLike)((AbstractHardcoreTorchBlock)state.m_60734_()).group.getStandingTorch(torchState).m_5456_());
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<TorchLootFunction> {
        public TorchLootFunction deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootConditions) {
            return new TorchLootFunction(lootConditions);
        }
    }
}

