/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.block;

import com.github.wolfiewaffle.hardcore_torches.MainMod;
import com.github.wolfiewaffle.hardcore_torches.block.AbstractLanternBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.FuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SoulLanternBlock
extends AbstractLanternBlock {
    public static final int SOUL_LANTERN_LIGHT_LEVEL = 10;
    public static final int bottleAmount = 100;

    public SoulLanternBlock(BlockBehaviour.Properties prop, boolean isLit, IntSupplier maxFuel) {
        super(prop, isLit, maxFuel);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        BlockEntity be = world.m_7702_(pos);
        if (player.m_6047_() && ((Boolean)Config.pickUpLanterns.get()).booleanValue()) {
            if (!world.f_46443_) {
                player.m_36356_(this.getStack(world, pos));
            }
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            if (!world.f_46443_) {
                world.m_5594_(null, pos, SoundEvents.f_12028_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() instanceof ExperienceBottleItem) {
            if (be instanceof FuelBlockEntity && !world.f_46443_) {
                SoulLanternBlock.fuelBlock((FuelBlockEntity)be, world, stack, 100, true);
                world.m_5594_(null, pos, SoundEvents.f_11771_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.displayFuel(player, ((FuelBlockEntity)be).getFuel());
            }
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_204117_(MainMod.SOUL_ITEMS)) {
            if (be instanceof FuelBlockEntity && !world.f_46443_) {
                int maxExp = Math.min(player.f_36079_, (Integer)Config.expIncrement.get());
                int maxAmount = Math.max(0, this.getMaxFuel() - ((FuelBlockEntity)be).getFuel());
                int addAmount = Math.min(maxAmount, (int)((double)maxExp * (Double)Config.soulExpRatio.get()));
                int takeAmount = (int)Math.max(0.0, Math.ceil((double)addAmount / (Double)Config.soulExpRatio.get()));
                if (addAmount > 0) {
                    SoulLanternBlock.fuelBlock((FuelBlockEntity)be, world, stack, addAmount, false);
                    player.m_6756_(-takeAmount);
                    world.m_5594_(null, pos, SoundEvents.f_11771_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.displayFuel(player, ((FuelBlockEntity)be).getFuel());
                }
            }
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        boolean showFuel = (Boolean)Config.fuelMessage.get();
        if (be.m_58903_() == BlockEntityInit.LANTERN_BLOCK_ENTITY.get() && hand == InteractionHand.MAIN_HAND && !world.f_46443_ && showFuel) {
            this.displayFuel(player, ((FuelBlockEntity)be).getFuel());
        }
        if (!this.isLit && this.itemValid(stack, ETorchState.LIT)) {
            return this.attemptLight(world, pos, state, player, stack, hand);
        }
        return InteractionResult.PASS;
    }

    private void displayFuel(Player player, int amount) {
        player.m_5661_((Component)Component.m_237113_((String)("Spirit: " + amount)), true);
    }

    public static boolean fuelBlock(FuelBlockEntity be, Level world, ItemStack stack, int amount, boolean consume) {
        if (!world.f_46443_) {
            if (consume) {
                stack.m_41769_(-1);
            }
            be.setFuel(be.getFuel() + amount);
        }
        return true;
    }

    @Override
    public TagKey getFreeLightItems() {
        return MainMod.FREE_LANTERN_LIGHT_ITEMS;
    }

    @Override
    public TagKey getDamageLightItems() {
        return MainMod.DAMAGE_LANTERN_LIGHT_ITEMS;
    }

    @Override
    public TagKey getConsumeLightItems() {
        return MainMod.CONSUME_LANTERN_LIGHT_ITEMS;
    }
}

