/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.block;

import com.github.wolfiewaffle.hardcore_torches.MainMod;
import com.github.wolfiewaffle.hardcore_torches.blockentity.FuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.TorchBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import com.github.wolfiewaffle.hardcore_torches.item.OilCanItem;
import com.github.wolfiewaffle.hardcore_torches.item.TorchItem;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.github.wolfiewaffle.hardcore_torches.util.TorchGroup;
import com.github.wolfiewaffle.hardcore_torches.util.TorchTools;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHardcoreTorchBlock
extends BaseEntityBlock
implements IFuelBlock,
EntityBlock {
    public SimpleParticleType particle;
    public ETorchState burnState;
    public TorchGroup group;
    public static final BlockEntityTicker<TorchBlockEntity> TICKER = (level, pos, state, be) -> be.tick();
    public IntSupplier maxFuel;

    public AbstractHardcoreTorchBlock(BlockBehaviour.Properties prop, SimpleParticleType particle, ETorchState burnState, TorchGroup group, IntSupplier maxFuel) {
        super(prop);
        this.particle = particle;
        this.burnState = burnState;
        this.group = group;
        this.maxFuel = maxFuel;
    }

    public abstract boolean isWall();

    @Override
    public int getMaxFuel() {
        return this.maxFuel.getAsInt();
    }

    @Override
    public boolean canLight(Level world, BlockPos pos) {
        return this.burnState != ETorchState.BURNT && this.burnState != ETorchState.LIT;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (this.burnState == ETorchState.LIT) {
            if (this.attemptUseItem(stack, player, hand, ETorchState.UNLIT)) {
                this.extinguish(world, pos, state);
                player.m_6674_(hand);
                return InteractionResult.SUCCESS;
            }
            if (this.attemptUseItem(stack, player, hand, ETorchState.SMOLDERING)) {
                this.smother(world, pos, state);
                player.m_6674_(hand);
                return InteractionResult.SUCCESS;
            }
        }
        if ((this.burnState == ETorchState.SMOLDERING || this.burnState == ETorchState.UNLIT) && this.attemptUseItem(stack, player, hand, ETorchState.LIT)) {
            this.light(world, pos, state);
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = world.m_7702_(pos);
        if (be.m_58903_() == BlockEntityInit.TORCH_BLOCK_ENTITY.get() && !world.f_46443_ && ((Boolean)Config.fuelMessage.get()).booleanValue() && stack.m_41619_()) {
            player.m_5661_((Component)Component.m_237113_((String)("Fuel: " + ((TorchBlockEntity)be).getFuel())), true);
        }
        if (((Boolean)Config.torchesUseCan.get()).booleanValue() && this.burnState != ETorchState.BURNT && !world.f_46443_ && OilCanItem.fuelBlock((FuelBlockEntity)be, world, stack)) {
            world.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (((Boolean)Config.handUnlightTorch.get()).booleanValue() && (this.burnState == ETorchState.LIT || this.burnState == ETorchState.SMOLDERING) && !TorchTools.canLight(stack.m_41720_(), this.m_49966_())) {
            this.extinguish(world, pos, state);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        BlockEntity be = world.m_7702_(pos);
        if (be != null && be instanceof FuelBlockEntity && itemStack.m_41720_() instanceof TorchItem) {
            int fuel = TorchItem.getFuel(itemStack);
            if (fuel == 0) {
                ((FuelBlockEntity)be).setFuel(this.getMaxFuel());
            } else {
                ((FuelBlockEntity)be).setFuel(fuel);
            }
        }
    }

    public static boolean isLightItem(ItemStack stack) {
        if (stack.m_204117_(MainMod.FREE_TORCH_LIGHT_ITEMS)) {
            return true;
        }
        if (stack.m_204117_(MainMod.DAMAGE_TORCH_LIGHT_ITEMS)) {
            return true;
        }
        return stack.m_204117_(MainMod.CONSUME_TORCH_LIGHT_ITEMS);
    }

    public void smother(Level world, BlockPos pos, BlockState state) {
        if (!world.f_46443_) {
            world.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            TorchTools.displayParticle(ParticleTypes.f_123755_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123755_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123762_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123762_, state, world, pos);
            this.changeTorch(world, pos, state, ETorchState.SMOLDERING);
        }
    }

    public void extinguish(Level world, BlockPos pos, BlockState state) {
        if (!world.f_46443_) {
            world.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            TorchTools.displayParticle(ParticleTypes.f_123755_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123755_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123762_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123762_, state, world, pos);
            this.changeTorch(world, pos, state, ETorchState.UNLIT);
        }
    }

    public void burnOut(Level world, BlockPos pos, BlockState state, boolean playSound) {
        if (!world.f_46443_) {
            if (playSound) {
                world.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            TorchTools.displayParticle(ParticleTypes.f_123755_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123755_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123762_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123762_, state, world, pos);
            this.changeTorch(world, pos, state, ETorchState.BURNT);
        }
    }

    public void light(Level world, BlockPos pos, BlockState state) {
        if (!world.f_46443_) {
            world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 0.5f, 1.2f);
            TorchTools.displayParticle(ParticleTypes.f_123756_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123744_, state, world, pos);
            this.changeTorch(world, pos, state, ETorchState.LIT);
        }
    }

    public void changeTorch(Level world, BlockPos pos, BlockState curState, ETorchState newType) {
        BlockState newState = this.isWall() ? this.group.getWallTorch(newType).m_152465_(curState) : this.group.getStandingTorch(newType).m_152465_(curState);
        int newFuel = 0;
        if (world.m_7702_(pos) != null) {
            newFuel = ((FuelBlockEntity)world.m_7702_(pos)).getFuel();
        }
        world.m_46597_(pos, newState);
        if (world.m_7702_(pos) != null) {
            ((FuelBlockEntity)world.m_7702_(pos)).setFuel(newFuel);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (this.burnState == ETorchState.LIT || this.burnState == ETorchState.SMOLDERING) {
            return type == BlockEntityInit.TORCH_BLOCK_ENTITY.get() ? (level, pos, blockState, be) -> ((TorchBlockEntity)be).tick() : super.m_142354_(world, state, type);
        }
        return null;
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        TorchBlockEntity be = new TorchBlockEntity(pos, state);
        be.setFuel(this.getMaxFuel());
        return be;
    }

    @Override
    public void outOfFuel(Level world, BlockPos pos, BlockState state) {
        this.burnOut(world, pos, state, false);
    }
}

