/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.structure;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.util.MathUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import org.apache.commons.lang3.tuple.Triple;

public class StructureHandler {
    private static final HashMultimap<ResourceLocation, Tuple<ResourceLocation, Setter>> STRUCTURE_PIECE_TO_TILE_MAP = HashMultimap.create();
    private static final Multimap<ResourceLocation, Tuple<ResourceLocation, Setter>> JIGSAW_TO_TILE_MAP = HashMultimap.create();
    private static final Map<ResourceLocation, Tuple<ResourceLocation, Component>> STRUCTURE_PIECE_TO_MARKER_MAP = new HashMap<ResourceLocation, Tuple<ResourceLocation, Component>>();
    private static final Map<TagKey<Structure>, Tuple<ResourceLocation, Component>> STRUCTURE_TAG_TO_MARKER_MAP = new HashMap<TagKey<Structure>, Tuple<ResourceLocation, Component>>();
    private static final Map<ResourceLocation, Integer> STRUCTURE_PIECE_TILE_PRIORITY = new HashMap<ResourceLocation, Integer>();
    public static final Setter ALWAYS = (world, element, box, rotation) -> Collections.singleton(new ChunkPos(MathUtil.getCenter(box).m_123341_() >> 4, MathUtil.getCenter(box).m_123343_() >> 4));
    private static final Set<Triple<Integer, Integer, ResourceLocation>> VISITED_STRUCTURES = Collections.newSetFromMap(new ConcurrentHashMap());

    public static Collection<ChunkPos> IF_X_DIRECTION(Level ignoredWorld, StructurePoolElement ignoredElement, BoundingBox box, StructurePiece piece) {
        if (piece instanceof PoolElementStructurePiece) {
            PoolElementStructurePiece poolPiece = (PoolElementStructurePiece)piece;
            List junctions = poolPiece.m_72648_();
            if (junctions.size() == 2) {
                if (((JigsawJunction)junctions.get(0)).m_210252_() == ((JigsawJunction)junctions.get(1)).m_210252_() || ((JigsawJunction)junctions.get(0)).m_210258_() != ((JigsawJunction)junctions.get(1)).m_210258_()) {
                    return Collections.singleton(new ChunkPos(MathUtil.getCenter(box)));
                }
            } else {
                return Collections.singleton(new ChunkPos(MathUtil.getCenter(box)));
            }
        }
        return Collections.emptyList();
    }

    public static Collection<ChunkPos> IF_Z_DIRECTION(Level ignoredWorld, StructurePoolElement ignoredElement, BoundingBox box, StructurePiece piece) {
        if (piece instanceof PoolElementStructurePiece) {
            PoolElementStructurePiece poolPiece = (PoolElementStructurePiece)piece;
            List junctions = poolPiece.m_72648_();
            if (junctions.size() == 2) {
                if (((JigsawJunction)junctions.get(0)).m_210258_() == ((JigsawJunction)junctions.get(1)).m_210258_() || ((JigsawJunction)junctions.get(0)).m_210252_() != ((JigsawJunction)junctions.get(1)).m_210252_()) {
                    return Collections.singleton(new ChunkPos(MathUtil.getCenter(box)));
                }
            } else {
                return Collections.singleton(new ChunkPos(MathUtil.getCenter(box)));
            }
        }
        return Collections.emptyList();
    }

    public static void registerTile(StructurePieceType structurePieceType, int priority, ResourceLocation textureId, Setter setter) {
        ResourceLocation id = Registry.f_122843_.m_7981_((Object)structurePieceType);
        STRUCTURE_PIECE_TO_TILE_MAP.put((Object)id, (Object)new Tuple((Object)textureId, (Object)setter));
        STRUCTURE_PIECE_TILE_PRIORITY.put(textureId, priority);
    }

    public static void registerTile(StructurePieceType structurePieceType, int priority, ResourceLocation textureId) {
        StructureHandler.registerTile(structurePieceType, priority, textureId, ALWAYS);
    }

    public static void registerJigsawTile(ResourceLocation jigsawPattern, int priority, ResourceLocation tileID, Setter setter) {
        JIGSAW_TO_TILE_MAP.put((Object)jigsawPattern, (Object)new Tuple((Object)tileID, (Object)setter));
        STRUCTURE_PIECE_TILE_PRIORITY.put(tileID, priority);
    }

    public static void registerJigsawTile(ResourceLocation jigsawPattern, int priority, ResourceLocation tileID) {
        StructureHandler.registerJigsawTile(jigsawPattern, priority, tileID, ALWAYS);
    }

    public static void registerMarker(StructureType<?> structureFeature, ResourceLocation markerType, Component name) {
        STRUCTURE_PIECE_TO_MARKER_MAP.put(Registry.f_235740_.m_7981_(structureFeature), (Tuple<ResourceLocation, Component>)new Tuple((Object)markerType, (Object)name));
    }

    public static void registerMarker(TagKey<Structure> structureTag, ResourceLocation markerType, Component name) {
        STRUCTURE_TAG_TO_MARKER_MAP.put(structureTag, (Tuple<ResourceLocation, Component>)new Tuple((Object)markerType, (Object)name));
    }

    private static int getPriority(ResourceLocation structurePieceId) {
        return STRUCTURE_PIECE_TILE_PRIORITY.getOrDefault(structurePieceId, Integer.MAX_VALUE);
    }

    private static void put(Level world, int chunkX, int chunkZ, ResourceLocation textureId) {
        ResourceLocation existingTile = AtlasAPI.getTileAPI().getGlobalTile(world, chunkX, chunkZ);
        if (StructureHandler.getPriority(textureId) < StructureHandler.getPriority(existingTile)) {
            AtlasAPI.getTileAPI().putGlobalTile(world, textureId, chunkX, chunkZ);
        }
    }

    private static void resolveJigsaw(StructurePiece jigsawPiece, ServerLevel world) {
        PoolElementStructurePiece pool;
        StructurePoolElement structurePoolElement;
        if (jigsawPiece instanceof PoolElementStructurePiece && (structurePoolElement = (pool = (PoolElementStructurePiece)jigsawPiece).m_209918_()) instanceof SinglePoolElement) {
            SinglePoolElement singlePoolElement = (SinglePoolElement)structurePoolElement;
            Optional left = singlePoolElement.f_210411_.left();
            if (left.isPresent()) {
                for (Tuple entry : JIGSAW_TO_TILE_MAP.get((Object)((ResourceLocation)left.get()))) {
                    ResourceLocation tile = (ResourceLocation)entry.m_14418_();
                    Setter setter = (Setter)entry.m_14419_();
                    for (ChunkPos pos : setter.matches((Level)world, (StructurePoolElement)singlePoolElement, pool.m_73547_(), jigsawPiece)) {
                        StructureHandler.put((Level)world, pos.f_45578_, pos.f_45579_, tile);
                    }
                }
            }
        }
    }

    public static void resolve(StructurePiece structurePiece, ServerLevel world) {
        if (structurePiece.m_210000_() == StructurePieceType.f_210125_) {
            StructureHandler.resolveJigsaw(structurePiece, world);
            return;
        }
        ResourceLocation structurePieceId = Registry.f_122843_.m_7981_((Object)structurePiece.m_210000_());
        if (STRUCTURE_PIECE_TO_TILE_MAP.containsKey((Object)structurePieceId)) {
            for (Tuple entry : STRUCTURE_PIECE_TO_TILE_MAP.get((Object)structurePieceId)) {
                Collection<ChunkPos> matches;
                if (structurePiece instanceof PoolElementStructurePiece) {
                    PoolElementStructurePiece pool = (PoolElementStructurePiece)structurePiece;
                    matches = ((Setter)entry.m_14419_()).matches((Level)world, pool.m_209918_(), pool.m_73547_(), structurePiece);
                } else {
                    matches = ((Setter)entry.m_14419_()).matches((Level)world, null, structurePiece.m_73547_(), structurePiece);
                }
                for (ChunkPos pos : matches) {
                    StructureHandler.put((Level)world, pos.f_45578_, pos.f_45579_, (ResourceLocation)entry.m_14418_());
                }
            }
        }
    }

    public static void resolve(StructureStart structureStart, ServerLevel world) {
        ResourceLocation structureId = Registry.f_235740_.m_7981_((Object)structureStart.m_226861_().m_213658_());
        Tuple<ResourceLocation, Component> foundMarker = null;
        if (STRUCTURE_PIECE_TO_MARKER_MAP.containsKey(structureId)) {
            foundMarker = STRUCTURE_PIECE_TO_MARKER_MAP.get(structureId);
        } else {
            Registry structureRegistry = world.m_5962_().m_175515_(Registry.f_235725_);
            Holder structureTag = structureRegistry.m_206081_((ResourceKey)structureRegistry.m_7854_((Object)structureStart.m_226861_()).orElse(null));
            for (Map.Entry<TagKey<Structure>, Tuple<ResourceLocation, Component>> entry : STRUCTURE_TAG_TO_MARKER_MAP.entrySet()) {
                if (!structureTag.m_203656_(entry.getKey())) continue;
                foundMarker = entry.getValue();
                break;
            }
        }
        if (foundMarker != null) {
            Triple key = Triple.of((Object)structureStart.m_73601_().m_162394_().m_123341_(), (Object)structureStart.m_73601_().m_162394_().m_123342_(), (Object)structureId);
            if (VISITED_STRUCTURES.contains(key)) {
                return;
            }
            VISITED_STRUCTURES.add((Triple<Integer, Integer, ResourceLocation>)key);
            AtlasAPI.getMarkerAPI().putGlobalMarker((Level)world, false, (ResourceLocation)foundMarker.m_14418_(), (Component)foundMarker.m_14419_(), structureStart.m_73601_().m_162394_().m_123341_(), structureStart.m_73601_().m_162394_().m_123343_());
        }
    }

    static interface Setter {
        public Collection<ChunkPos> matches(Level var1, StructurePoolElement var2, BoundingBox var3, StructurePiece var4);
    }
}

