/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.gui.options.control;

import com.mojang.blaze3d.vertex.PoseStack;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.Validate;

public class SliderControlExtended
implements Control<Integer> {
    private final Option<Integer> option;
    private final int min;
    private final int max;
    private final int interval;
    private final ControlValueFormatter mode;
    private final boolean displayIntValueWhileSliding;

    public SliderControlExtended(Option<Integer> option, int min, int max, int interval, ControlValueFormatter mode, boolean displayIntValueWhileSliding) {
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"The maximum value must be greater than the minimum value", (Object[])new Object[0]);
        Validate.isTrue((interval > 0 ? 1 : 0) != 0, (String)"The slider interval must be greater than zero", (Object[])new Object[0]);
        Validate.isTrue(((max - min) % interval == 0 ? 1 : 0) != 0, (String)"The maximum value must be divisable by the interval", (Object[])new Object[0]);
        Validate.notNull((Object)mode, (String)"The slider mode must not be null", (Object[])new Object[0]);
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.mode = mode;
        this.displayIntValueWhileSliding = displayIntValueWhileSliding;
    }

    public ControlElement<Integer> createElement(Dim2i dim) {
        return new Slider(this.option, dim, this.min, this.max, this.interval, this.mode, this.displayIntValueWhileSliding);
    }

    public Option<Integer> getOption() {
        return this.option;
    }

    public int getMaxWidth() {
        return 130;
    }

    private static class Slider
    extends ControlElement<Integer> {
        private static final int THUMB_WIDTH = 2;
        private static final int TRACK_HEIGHT = 1;
        private final Rect2i sliderBounds;
        private final ControlValueFormatter formatter;
        private final boolean displayIntValueWhileSliding;
        private final int min;
        private final int range;
        private final int interval;
        private double thumbPosition;

        public Slider(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter, boolean displayIntValueWhileSliding) {
            super(option, dim);
            this.min = min;
            this.range = max - min;
            this.interval = interval;
            this.thumbPosition = this.getThumbPositionForValue((Integer)option.getValue());
            this.formatter = formatter;
            this.displayIntValueWhileSliding = displayIntValueWhileSliding;
            this.sliderBounds = new Rect2i(dim.getLimitX() - 96, dim.getCenterY() - 5, 90, 10);
        }

        public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float delta) {
            super.m_6305_(matrixStack, mouseX, mouseY, delta);
            if (this.option.isAvailable() && this.hovered) {
                this.renderSlider(matrixStack);
            } else {
                this.renderStandaloneValue(matrixStack);
            }
        }

        private void renderStandaloneValue(PoseStack matrixStack) {
            int sliderX = this.sliderBounds.m_110085_();
            int sliderY = this.sliderBounds.m_110086_();
            int sliderWidth = this.sliderBounds.m_110090_();
            int sliderHeight = this.sliderBounds.m_110091_();
            String label = this.formatter.format(((Integer)this.option.getValue()).intValue());
            int labelWidth = this.font.m_92895_(label);
            this.drawString(matrixStack, label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 - 4, -1);
        }

        private void renderSlider(PoseStack matrixStack) {
            int sliderX = this.sliderBounds.m_110085_();
            int sliderY = this.sliderBounds.m_110086_();
            int sliderWidth = this.sliderBounds.m_110090_();
            int sliderHeight = this.sliderBounds.m_110091_();
            this.thumbPosition = this.getThumbPositionForValue((Integer)this.option.getValue());
            double thumbOffset = Mth.m_14008_((double)((double)(this.getIntValue() - this.min) / (double)this.range * (double)sliderWidth), (double)0.0, (double)sliderWidth);
            double thumbX = (double)sliderX + thumbOffset - 2.0;
            double trackY = (double)(sliderY + sliderHeight / 2) - 0.5;
            this.drawRect(thumbX, sliderY, thumbX + 4.0, sliderY + sliderHeight, -1);
            this.drawRect(sliderX, trackY, sliderX + sliderWidth, trackY + 1.0, -1);
            String label = this.displayIntValueWhileSliding ? String.valueOf(this.getIntValue()) : this.formatter.format(((Integer)this.option.getValue()).intValue());
            int labelWidth = this.font.m_92895_(label);
            this.drawString(matrixStack, label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 - 4, -1);
        }

        public int getIntValue() {
            return this.min + this.interval * (int)Math.round(this.getSnappedThumbPosition() / (double)this.interval);
        }

        public double getSnappedThumbPosition() {
            return this.thumbPosition / (1.0 / (double)this.range);
        }

        public double getThumbPositionForValue(int value) {
            return (double)(value - this.min) * (1.0 / (double)this.range);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.sliderBounds.m_110087_((int)mouseX, (int)mouseY)) {
                this.setValueFromMouse(mouseX);
                return true;
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            this.setValue((d - (double)this.sliderBounds.m_110085_()) / (double)this.sliderBounds.m_110090_());
        }

        private void setValue(double d) {
            this.thumbPosition = Mth.m_14008_((double)d, (double)0.0, (double)1.0);
            int value = this.getIntValue();
            if ((Integer)this.option.getValue() != value) {
                this.option.setValue((Object)value);
            }
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.option.isAvailable() && button == 0) {
                this.setValueFromMouse(mouseX);
                return true;
            }
            return false;
        }
    }
}

