/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.dynamic_resources.ctm;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.chisel.ctm.CTM;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.util.ResourceUtil;
import team.chisel.ctm.client.util.TextureMetadataHandler;

@Mixin(value={TextureMetadataHandler.class})
@RequiresMod(value="ctm")
@ClientOnlyMixin
public abstract class TextureMetadataHandlerMixin
implements ModernFixClientIntegration {
    @Shadow(remap=false)
    @Nonnull
    protected abstract BakedModel wrap(ResourceLocation var1, UnbakedModel var2, BakedModel var3, ModelBakery var4) throws IOException;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void subscribeDynamic(CallbackInfo ci) {
        ModernFixClient.CLIENT_INTEGRATIONS.add(this);
    }

    @Inject(method={"onModelBake"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void noIteration(CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public BakedModel onBakedModelLoad(ResourceLocation rl, UnbakedModel rootModel, BakedModel baked, ModelState state, ModelBakery bakery) {
        if (rl instanceof ModelResourceLocation && !(baked instanceof AbstractCTMBakedModel) && !baked.m_7521_()) {
            ArrayDeque<ResourceLocation> dependencies = new ArrayDeque<ResourceLocation>();
            HashSet<ResourceLocation> seenModels = new HashSet<ResourceLocation>();
            dependencies.push(rl);
            seenModels.add(rl);
            boolean shouldWrap = false;
            HashSet errors = new HashSet();
            while (!shouldWrap && !dependencies.isEmpty()) {
                UnbakedModel model;
                ResourceLocation dep = (ResourceLocation)dependencies.pop();
                try {
                    model = dep == rl ? rootModel : bakery.m_119341_(dep);
                }
                catch (Exception e) {
                    continue;
                }
                Collection textures = model.m_5500_(arg_0 -> ((ModelBakery)bakery).m_119341_(arg_0), errors);
                Collection newDependencies = model.m_7970_();
                for (Material tex : textures) {
                    IMetadataSectionCTM meta = null;
                    try {
                        meta = ResourceUtil.getMetadata((ResourceLocation)ResourceUtil.spriteToAbsolute((ResourceLocation)tex.m_119203_())).orElse(null);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (meta == null) continue;
                    shouldWrap = true;
                }
                for (ResourceLocation newDep : newDependencies) {
                    if (!seenModels.add(newDep)) continue;
                    dependencies.push(newDep);
                }
            }
            if (shouldWrap) {
                try {
                    baked = this.wrap(rl, rootModel, baked, bakery);
                    dependencies.clear();
                }
                catch (IOException e) {
                    CTM.logger.error("Could not wrap model " + rl + ". Aborting...", (Throwable)e);
                }
            }
        }
        return baked;
    }
}

