/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.ecostackmanager.entity;

import de.markusbordihn.ecostackmanager.Constants;
import de.markusbordihn.ecostackmanager.entity.ExperienceOrbManager;
import de.markusbordihn.ecostackmanager.entity.ItemEntityManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntityWorldEvents {
    private EntityWorldEvents() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        if (event.isCanceled()) return;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) return;
        ServerLevel serverLevel = (ServerLevel)level;
        Entity entity = event.getEntity();
        if (entity instanceof ExperienceOrb) {
            ExperienceOrb experienceOrb = (ExperienceOrb)entity;
            if (!Constants.MOD_CLUMPS_LOADED) {
                if (!ExperienceOrbManager.handleExperienceOrbJoinWorldEvent(experienceOrb, serverLevel)) return;
                if (!event.isCancelable()) return;
                event.setCanceled(true);
                return;
            }
        }
        if (!((entity = event.getEntity()) instanceof ItemEntity)) return;
        ItemEntity itemEntity = (ItemEntity)entity;
        if (Constants.MOD_CLUMPS_LOADED) return;
        if (!ItemEntityManager.handleItemJoinWorldEvent(itemEntity, serverLevel)) return;
        if (!event.isCancelable()) return;
        event.setCanceled(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityLeaveWorldEvent(EntityLeaveLevelEvent event) {
        if (event.isCanceled()) return;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) return;
        ServerLevel serverLevel = (ServerLevel)level;
        Entity entity = event.getEntity();
        if (entity instanceof ExperienceOrb) {
            ExperienceOrb experienceOrb = (ExperienceOrb)entity;
            if (!Constants.MOD_CLUMPS_LOADED) {
                ExperienceOrbManager.handleExperienceOrbLeaveWorldEvent(experienceOrb, serverLevel);
                return;
            }
        }
        if (!((entity = event.getEntity()) instanceof ItemEntity)) return;
        ItemEntity itemEntity = (ItemEntity)entity;
        if (Constants.MOD_CLUMPS_LOADED) return;
        ItemEntityManager.handleItemLeaveWorldEvent(itemEntity, serverLevel);
    }
}

