/*
 * Decompiled with CFR 0.152.
 */
package com.bigenergy.ftbquestsoptimizer.mixin;

import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftbquests.item.MissingItem;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ItemTask.class}, remap=false)
public class ItemTaskMixin
extends Task
implements Predicate<ItemStack> {
    @Shadow
    public boolean taskScreenOnly;
    @Shadow
    public Tristate onlyFromCrafting;
    @Shadow
    public long count;
    @Shadow
    public ItemStack item;

    public ItemTaskMixin(Quest q) {
        super(q);
    }

    @Shadow
    public TaskType getType() {
        return null;
    }

    @Shadow
    public ItemStack insert(TeamData teamData, ItemStack stack, boolean simulate) {
        long add;
        if (!teamData.isCompleted((QuestObject)this) && this.consumesResources() && this.test(stack) && (add = Math.min((long)stack.m_41613_(), this.count - teamData.getProgress((Task)this))) > 0L) {
            if (!simulate && teamData.file.isServerSide()) {
                teamData.addProgress((Task)this, add);
            }
            ItemStack copy = stack.m_41777_();
            copy.m_41764_((int)((long)stack.m_41613_() - add));
            return copy;
        }
        return stack;
    }

    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        if (this.taskScreenOnly || teamData.isCompleted((QuestObject)this) || this.item.m_41720_() instanceof MissingItem || craftedItem.m_41720_() instanceof MissingItem) {
            return;
        }
        if (!this.consumesResources()) {
            if (this.onlyFromCrafting.get(false)) {
                if (!craftedItem.m_41619_() && this.test(craftedItem)) {
                    teamData.addProgress((Task)this, (long)craftedItem.m_41613_());
                }
            } else {
                long c = Math.min(this.count, 0L);
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    if (!this.test(stack)) continue;
                    c += (long)stack.m_41613_();
                }
                long progress = teamData.getProgress((Task)this);
                if (c > progress) {
                    teamData.setProgress((Task)this, c);
                }
            }
        } else if (craftedItem.m_41619_()) {
            boolean changed = false;
            NonNullList inventory = player.m_150109_().f_35974_;
            int inventorySize = inventory.size();
            for (int i = 0; i < inventorySize; ++i) {
                ItemStack stack1;
                ItemStack stack = (ItemStack)inventory.get(i);
                if (stack == (stack1 = this.insert(teamData, stack, false))) continue;
                changed = true;
                inventory.set(i, stack1.m_41619_() ? ItemStack.f_41583_ : stack1);
            }
            if (changed) {
                player.m_150109_().m_6596_();
                if (player.f_36096_ != null) {
                    player.f_36096_.m_38946_();
                }
            }
        }
    }

    @Override
    @Shadow
    public boolean test(ItemStack itemStack) {
        return false;
    }
}

