/*
 * Decompiled with CFR 0.152.
 */
package com.bigenergy.ftbquestsoptimizer.mixin;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.FTBQuestsInventoryListener;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FTBQuestsInventoryListener.class}, remap=false)
public class FTBQuestsInventoryListenerMixin {
    @Shadow
    public final ServerPlayer player;
    private int ticksSkipped;

    public FTBQuestsInventoryListenerMixin(ServerPlayer player) {
        this.player = player;
    }

    private boolean tryTick() {
        int skipTicksAmount = 5;
        if (skipTicksAmount <= 0) {
            return true;
        }
        ++this.ticksSkipped;
        if (this.ticksSkipped > skipTicksAmount) {
            this.ticksSkipped = 0;
            return true;
        }
        return false;
    }

    @Overwrite
    public static void detect(ServerPlayer player, ItemStack craftedItem, long sourceTask) {
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file == null || PlayerHooks.isFake((Player)player)) {
            return;
        }
        TeamData data = file.getNullableTeamData(FTBTeamsAPI.getPlayerTeamID((UUID)player.m_20148_()));
        if (data == null || data.isLocked()) {
            return;
        }
        file.withPlayerContext(player, () -> file.getSubmitTasks().stream().filter(task -> task.id != sourceTask && data.canStartTasks(task.quest)).forEach(task -> task.submitTask(data, player, craftedItem)));
    }

    public void slotChanged(AbstractContainerMenu container, int index, ItemStack stack) {
        if (!this.tryTick()) {
            return;
        }
        if (!stack.m_41619_() && container.m_38853_((int)index).f_40218_ == this.player.m_150109_()) {
            FTBQuestsInventoryListenerMixin.detect(this.player, ItemStack.f_41583_, 0L);
        }
    }
}

