/*
 * Decompiled with CFR 0.152.
 */
package shadows.fastsuite;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.VisibleForTesting;
import shadows.fastsuite.FastSuite;
import shadows.fastsuite.ILockableItemStack;
import shadows.fastsuite.StreamUtils;

public class AuxRecipeManager
extends RecipeManager {
    @Deprecated
    public AuxRecipeManager() {
    }

    public AuxRecipeManager(ICondition.IContext context) {
        super(context);
    }

    @VisibleForTesting
    public <C extends Container, T extends Recipe<C>> Optional<T> super_getRecipeFor(RecipeType<T> type, C inv, Level level) {
        return super.m_44015_(type, inv, level);
    }

    public <C extends Container, T extends Recipe<C>> Optional<T> m_44015_(RecipeType<T> type, C inv, Level level) {
        if (this.numRecipesOf(type) < 100 || FastSuite.singleThreadedLookups.contains(type)) {
            return super.m_44015_(type, inv, level);
        }
        this.lockAllStacks(inv, true);
        try {
            Optional optional = StreamUtils.executeUntil(() -> this.byType(type).values().parallelStream().filter(recipe -> recipe.m_5818_(inv, level)).findFirst(), FastSuite.maxRecipeLookupTime, TimeUnit.SECONDS, Optional.empty(), () -> AuxRecipeManager.timeoutMsg(type));
            return optional;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.lockAllStacks(inv, false);
        }
    }

    public <C extends Container, T extends Recipe<C>> List<T> m_44056_(RecipeType<T> type, C inv, Level level) {
        if (this.numRecipesOf(type) < 100 || FastSuite.singleThreadedLookups.contains(type)) {
            return super.m_44056_(type, inv, level);
        }
        this.lockAllStacks(inv, true);
        try {
            List list = StreamUtils.executeUntil(() -> this.byType(type).values().parallelStream().filter(recipe -> recipe.m_5818_(inv, level)).sorted(Comparator.comparing(recipe -> recipe.m_8043_().m_41778_())).collect(Collectors.toList()), FastSuite.maxRecipeLookupTime, TimeUnit.SECONDS, Collections.emptyList(), () -> AuxRecipeManager.timeoutMsg(type));
            return list;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.lockAllStacks(inv, false);
        }
    }

    private <C extends Container> void lockAllStacks(C inv, boolean locked) {
        if (!FastSuite.lockInputStacks) {
            return;
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack s = inv.m_8020_(i);
            if (s.m_41619_()) continue;
            ((ILockableItemStack)s).setLocked(locked);
        }
    }

    private int numRecipesOf(RecipeType type) {
        return this.byType(type).size();
    }

    private <C extends Container, T extends Recipe<C>> Map<ResourceLocation, T> byType(RecipeType<T> pRecipeType) {
        return this.f_44007_.getOrDefault(pRecipeType, Collections.emptyMap());
    }

    private static String timeoutMsg(RecipeType<?> type) {
        return String.format("Multithreaded recipe lookup took longer than %d seconds - aborting and returning nothing. Consider blacklisting this recipe type (%s) in the config.", FastSuite.maxRecipeLookupTime, ForgeRegistries.RECIPE_TYPES.getKey(type));
    }
}

