/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.fastpaintings;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.fastpaintings.PaintingBlockModel;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.CustomGeometry;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;

public class PaintingBlockModelLoader
implements CustomModelLoader {
    public CustomGeometry deserialize(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        List<String> l = List.of("center", "top_bottom_left_right", "top_bottom_left", "top_bottom_right", "top_bottom", "top_left", "top_right", "top", "bottom_left", "bottom_right", "bottom_right_left", "bottom_right_top", "bottom", "left", "right", "right_left");
        Map<String, JsonElement> map = l.stream().collect(Collectors.toMap(s -> s, arg_0 -> ((JsonObject)json).get(arg_0)));
        return new Geometry(map);
    }

    private record Geometry(Map<String, JsonElement> models) implements CustomGeometry
    {
        public Collection<Material> getMaterials(Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            ArrayList<Material> l = new ArrayList<Material>();
            for (PaintingVariant v : Registry.f_235728_) {
                ResourceLocation r = Registry.f_235728_.m_7981_((Object)v);
                l.add(new Material(TextureAtlas.f_118259_, new ResourceLocation(r.m_135827_(), "painting/" + r.m_135815_())));
            }
            l.add(new Material(TextureAtlas.f_118259_, PaintingBlockModel.BACK_TEXTURE));
            return l;
        }

        public CustomBakedModel bake(ModelBakery modelBakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ResourceLocation location) {
            Map<String, BakedModel> map = this.models.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                JsonElement j = (JsonElement)e.getValue();
                BlockModel model = j.isJsonPrimitive() ? (BlockModel)modelBakery.m_119341_(ResourceLocation.m_135820_((String)j.getAsString())) : ClientPlatformHelper.parseBlockModel((JsonElement)j);
                return model.m_111449_(modelBakery, model, spriteGetter, transform, location, true);
            }));
            return new PaintingBlockModel(map);
        }
    }
}

