/*
 * Decompiled with CFR 0.152.
 */
package me.duncanruns.chunkumulator;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import me.duncanruns.chunkumulator.mixinint.ThreadedAnvilChunkStorageInt;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2596;
import net.minecraft.class_2617;
import net.minecraft.class_2818;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_7648;

public class PlayerChunkAccumulator {
    private static final class_2596<?> EMPTY_PACKET = new class_2617((Object2IntMap)new Object2IntOpenHashMap());
    private final class_3222 player;
    private final List<Courier> queuedPackages = new ArrayList<Courier>();
    private final AtomicBoolean readyForMore = new AtomicBoolean(true);

    public PlayerChunkAccumulator(class_3222 player) {
        this.player = player;
    }

    public void addChunk(class_1923 pos, class_1937 world) {
        Courier courier = new Courier(pos, world);
        courier.updateDistance();
        this.queuedPackages.add(courier);
    }

    public void tick() {
        if (!this.readyForMore.get()) {
            return;
        }
        if (this.queuedPackages.isEmpty()) {
            return;
        }
        this.readyForMore.set(false);
        this.queuedPackages.removeIf(courier -> ((Courier)courier).world != this.player.field_6002);
        this.queuedPackages.forEach(Courier::updateDistance);
        this.queuedPackages.stream().sorted(Comparator.comparingInt(o -> ((Courier)o).distance)).collect(Collectors.toList()).subList(0, Math.min(100, this.queuedPackages.size())).forEach(courier -> {
            this.queuedPackages.remove(courier);
            courier.sendToPlayer();
        });
        this.player.field_13987.method_14369(EMPTY_PACKET, class_7648.method_45084(() -> this.readyForMore.set(true)));
    }

    public void removeChunk(class_1923 chunkPos) {
        this.queuedPackages.removeIf(courier -> ((Courier)courier).chunkPos.equals((Object)chunkPos));
    }

    private class Courier {
        private final class_1923 chunkPos;
        private int distance;
        private final class_1937 world;

        Courier(class_1923 pos, class_1937 world) {
            this.chunkPos = pos;
            this.world = world;
        }

        void updateDistance() {
            class_2338 pos = PlayerChunkAccumulator.this.player.method_24515();
            this.distance = (int)this.chunkPos.method_33943(pos.method_10264()).method_10262((class_2382)pos);
        }

        public void sendToPlayer() {
            class_1937 world = ((PlayerChunkAccumulator)PlayerChunkAccumulator.this).player.field_6002;
            class_2818 chunk = world.method_8497(this.chunkPos.field_9181, this.chunkPos.field_9180);
            ((ThreadedAnvilChunkStorageInt)((class_3215)world.method_8398()).field_17254).chunkumulator$actuallySendChunkDataPackets(PlayerChunkAccumulator.this.player, chunk);
        }
    }
}

