/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.originsclasses.core.mixin.common.minecraft;

import dev.limonblaze.originsclasses.common.registry.OriginsClassesPowers;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.ModifyValueBlockPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyValueBlockConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin
extends BaseContainerBlockEntity {
    @Unique
    private static ServerPlayer CACHED_PLAYER;
    @Unique
    private static BlockPos CACHED_BLOCK_POS;

    protected AbstractFurnaceBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"awardUsedRecipesAndPopExperience"}, at={@At(value="HEAD")})
    private void originsClasses$cachePlayerAndPos(ServerPlayer player, CallbackInfo ci) {
        CACHED_PLAYER = player;
        CACHED_BLOCK_POS = this.f_58858_;
    }

    @Inject(method={"awardUsedRecipesAndPopExperience"}, at={@At(value="TAIL")})
    private void originsClasses$resetPlayerAndPos(ServerPlayer player, CallbackInfo ci) {
        CACHED_PLAYER = null;
        CACHED_BLOCK_POS = null;
    }

    @ModifyVariable(method={"createExperience"}, at=@At(value="HEAD"), argsOnly=true)
    private static float originsClasses$modifyRecipeXp(float xp) {
        if (CACHED_PLAYER != null && CACHED_BLOCK_POS != null) {
            xp = IPowerContainer.modify((Entity)CACHED_PLAYER, (PowerFactory)((ModifyValueBlockPower)OriginsClassesPowers.MODIFY_FURNACE_XP.get()), (float)xp, cp -> ((ConfiguredPower)cp.get()).isActive((Entity)CACHED_PLAYER) && ConfiguredBlockCondition.check((Holder)((ModifyValueBlockConfiguration)((ConfiguredPower)cp.get()).getConfiguration()).condition(), (LevelReader)AbstractFurnaceBlockEntityMixin.CACHED_PLAYER.f_19853_, (BlockPos)CACHED_BLOCK_POS));
        }
        return xp;
    }
}

