/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.text.StringCharacterIterator;
import java.util.List;
import java.util.Objects;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.option.IrisVideoSettings;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DebugScreenOverlay.class})
public abstract class MixinDebugScreenOverlay {
    @Unique
    private static final List<BufferPoolMXBean> iris$pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    @Unique
    private static final BufferPoolMXBean iris$directPool;

    @Inject(method={"getSystemInformation"}, at={@At(value="RETURN")})
    private void iris$appendShaderPackText(CallbackInfoReturnable<List<String>> cir) {
        List messages = (List)cir.getReturnValue();
        messages.add("");
        messages.add("[Oculus] Version: " + Iris.getFormattedVersion());
        messages.add("");
        if (Iris.getIrisConfig().areShadersEnabled()) {
            messages.add("[Oculus] Shaderpack: " + Iris.getCurrentPackName() + (Iris.isFallback() ? " (fallback)" : ""));
            Iris.getCurrentPack().ifPresent(pack -> messages.add("[Oculus] " + pack.getProfileInfo()));
            messages.add("[Oculus] Color space: " + IrisVideoSettings.colorSpace.name());
        } else {
            messages.add("[Oculus] Shaders are disabled");
        }
        messages.add(3, "Direct Buffers: +" + MixinDebugScreenOverlay.iris$humanReadableByteCountBin(iris$directPool.getMemoryUsed()));
        if (!Iris.isSodiumInstalled()) {
            messages.add(3, "Native Memory: +" + MixinDebugScreenOverlay.iris$humanReadableByteCountBin(MixinDebugScreenOverlay.iris$getNativeMemoryUsage()));
        }
    }

    @Inject(method={"getGameInformation"}, at={@At(value="RETURN")})
    private void iris$appendShadowDebugText(CallbackInfoReturnable<List<String>> cir) {
        List messages = (List)cir.getReturnValue();
        if (!Iris.isSodiumInstalled() && Iris.getCurrentPack().isPresent()) {
            messages.add(1, ChatFormatting.YELLOW + "[Oculus] Rubidium isn't installed; you will have poor performance.");
            messages.add(2, ChatFormatting.YELLOW + "[Oculus] Install Rubidium if you want to run benchmarks or get higher FPS!");
        }
        Iris.getPipelineManager().getPipeline().ifPresent(pipeline -> pipeline.addDebugText(messages));
    }

    @Unique
    private static String iris$humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.3f %ciB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }

    @Unique
    private static long iris$getNativeMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed();
    }

    static {
        BufferPoolMXBean found = null;
        for (BufferPoolMXBean pool : iris$pools) {
            if (!pool.getName().equals("direct")) continue;
            found = pool;
            break;
        }
        iris$directPool = Objects.requireNonNull(found);
    }
}

