/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.features.texture_handlers.ETFDirectory;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;

public class TrueRandomProvider
implements ETFApi.ETFVariantSuffixProvider {
    private final int suffixTotal;
    private final String packname;
    protected ETFApi.ETFVariantSuffixProvider.EntityRandomSeedFunction entityRandomSeedFunction = entity -> entity.etf$getUuid().hashCode();

    private TrueRandomProvider(String secondPack, int suffixes) {
        this.suffixTotal = suffixes;
        this.packname = secondPack;
    }

    @Nullable
    public static TrueRandomProvider of(ResourceLocation vanillaIdentifier) {
        ResourceManager resources = Minecraft.m_91087_().m_91098_();
        ResourceLocation second = ETFDirectory.getDirectoryVersionOf(ETFUtils2.addVariantNumberSuffix(vanillaIdentifier, 2));
        if (second != null) {
            String secondPack = resources.m_213713_(second).map(Resource::m_215506_).orElse(null);
            String vanillaPack = resources.m_213713_(vanillaIdentifier).map(Resource::m_215506_).orElse(null);
            if (secondPack != null && secondPack.equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(secondPack, vanillaPack))) {
                int totalTextureCount = 2;
                while (ETFDirectory.getDirectoryVersionOf(ETFUtils2.addVariantNumberSuffix(vanillaIdentifier, totalTextureCount + 1)) != null) {
                    ++totalTextureCount;
                }
                return new TrueRandomProvider(secondPack, totalTextureCount);
            }
        }
        return null;
    }

    public String getPackName() {
        return this.packname;
    }

    @Override
    public boolean entityCanUpdate(UUID uuid) {
        return false;
    }

    @Override
    public IntOpenHashSet getAllSuffixes() {
        IntOpenHashSet allSuffixes = new IntOpenHashSet();
        for (int i = 0; i < this.suffixTotal; ++i) {
            allSuffixes.add(i + 1);
        }
        return allSuffixes;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int getSuffixForETFEntity(ETFEntity entityToBeTested) {
        if (entityToBeTested == null) {
            return 0;
        }
        return Math.abs(this.entityRandomSeedFunction.toInt(entityToBeTested)) % this.suffixTotal + 1;
    }

    @Override
    public void setRandomSupplier(ETFApi.ETFVariantSuffixProvider.EntityRandomSeedFunction entityRandomSeedFunction) {
        if (entityRandomSeedFunction != null) {
            this.entityRandomSeedFunction = entityRandomSeedFunction;
        }
    }
}

