/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.entity_model_features.EMF;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFUtils;

@Mixin(value={BlockEntityRenderers.class})
public class MixinBlockEntityRendererFactories {
    @Unique
    private static final List<String> emf$renderers = new ArrayList<String>();

    @Inject(method={"reload"}, at={@At(value="RETURN")})
    private static void emf$clearMarker(BlockEntityRendererProvider.Context args, CallbackInfoReturnable<Map<BlockEntityType<?>, BlockEntityRenderer<?>>> cir) {
        if (EMF.testForForgeLoadingError()) {
            return;
        }
        EMFManager.getInstance().currentSpecifiedModelLoading = "";
        EMFManager.getInstance().currentBlockEntityTypeLoading = null;
        if (((EMFConfig)EMF.config().getConfig()).logModelCreationData || ((EMFConfig)EMF.config().getConfig()).modelExportMode != EMFConfig.ModelPrintMode.NONE) {
            EMFUtils.log("Identified block entity renderers: " + emf$renderers);
        }
        emf$renderers.clear();
    }

    @ModifyArg(method={"reload"}, at=@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V"), index=0)
    private static BiConsumer<BlockEntityType<?>, BlockEntityRendererProvider<?>> setEmf$Model(BiConsumer<BlockEntityType<?>, BlockEntityRendererProvider<?>> action) {
        return (type, factory) -> {
            MixinBlockEntityRendererFactories.setEmf$Model(type);
            action.accept((BlockEntityType<?>)type, (BlockEntityRendererProvider<?>)factory);
        };
    }

    @Unique
    private static void setEmf$Model(BlockEntityType type) {
        if (EMF.testForForgeLoadingError()) {
            return;
        }
        EMFManager.getInstance().currentBlockEntityTypeLoading = type;
        if (BlockEntityType.f_58928_.equals(type)) {
            EMFManager.getInstance().currentSpecifiedModelLoading = "enchanting_book";
        } else if (BlockEntityType.f_58908_.equals(type)) {
            EMFManager.getInstance().currentSpecifiedModelLoading = "lectern_book";
        } else if (Registry.f_122830_.m_7854_((Object)type).isPresent()) {
            ResourceLocation id = ((ResourceKey)Registry.f_122830_.m_7854_((Object)type).get()).m_135782_();
            EMFManager.getInstance().currentSpecifiedModelLoading = id.m_135827_().equals("minecraft") ? id.m_135815_() : id.m_135827_() + ":" + id.m_135815_();
        }
        emf$renderers.add(EMFManager.getInstance().currentSpecifiedModelLoading);
    }
}

