/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.effective_fg.particle_manager;

import bottomtextdanny.effective_fg.particle_manager.MutableSpriteSet;
import bottomtextdanny.effective_fg.particle_manager.ParticleCreator;
import bottomtextdanny.effective_fg.particle_manager.ParticleData;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.resources.ResourceLocation;

public class ParticleManager<T extends ParticleData> {
    public final T defaultData;
    final ImmutableSet<ResourceLocation> textures;
    final MutableSpriteSet spriteSet = new MutableSpriteSet();
    private final ParticleCreator<T> creator;

    public ParticleManager(T defaultData, List<ResourceLocation> textures, ParticleCreator<T> creator) {
        this.defaultData = defaultData;
        this.textures = ImmutableSet.copyOf(textures);
        this.creator = creator;
    }

    public void create(T data, ClientLevel level, double x, double y, double z, double xDelta, double yDelta, double zDelta) {
        Minecraft.m_91087_().f_91061_.m_107344_(this.creator.createParticle(data, this.spriteSet, level, x, y, z, xDelta, yDelta, zDelta));
    }

    public void create(ClientLevel level, double x, double y, double z, double xDelta, double yDelta, double zDelta) {
        Minecraft.m_91087_().f_91061_.m_107344_(this.creator.createParticle(this.defaultData, this.spriteSet, level, x, y, z, xDelta, yDelta, zDelta));
    }

    public Particle createParticle(T data, ClientLevel level, double x, double y, double z, double xDelta, double yDelta, double zDelta) {
        return this.creator.createParticle(data, this.spriteSet, level, x, y, z, xDelta, yDelta, zDelta);
    }

    public Particle createParticle(ClientLevel level, double x, double y, double z, double xDelta, double yDelta, double zDelta) {
        return this.creator.createParticle(this.defaultData, this.spriteSet, level, x, y, z, xDelta, yDelta, zDelta);
    }

    public SpriteSet spriteSet() {
        return this.spriteSet;
    }

    public int sprites() {
        return this.textures.size();
    }
}

