/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.effective_fg;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class Config {
    public final ForgeConfigSpec.BooleanValue splashes;
    public final ForgeConfigSpec.DoubleValue waterSplashAlpha;
    public final ForgeConfigSpec.BooleanValue cascades;
    public final ForgeConfigSpec.DoubleValue cascadeVolumeMultiplier;
    public final ForgeConfigSpec.DoubleValue cascadeSoundRange;
    public final ForgeConfigSpec.DoubleValue cascadeParticleAmountMultiplier;
    public final ForgeConfigSpec.IntValue rainRippleAbundance;
    public final ForgeConfigSpec.IntValue flowingWaterSplashiesAbundance;

    public Config(ForgeConfigSpec.Builder builder) {
        builder.push("Entity Splash");
        builder.comment("Generates Entity Splashes.");
        this.splashes = builder.define("splashes", true);
        builder.comment("Defines Water Splash Transparent Channel.");
        this.waterSplashAlpha = builder.defineInRange("splashAlpha", 0.6, 0.0, 1.0);
        builder.pop();
        builder.push("Cascades");
        builder.comment("Processes Cascades");
        this.cascades = builder.define("cascades", true);
        builder.comment("Defines Cascade Sound Volume.");
        this.cascadeVolumeMultiplier = builder.defineInRange("cascade volume", 1.0, 0.0, 100.0);
        builder.comment("Defines Cascade Sound Reach, Measured By Blocks.");
        this.cascadeSoundRange = builder.defineInRange("cascade sound range", 30.0, 0.0, 256.0);
        builder.comment("Defines Cascade Particle Amount.");
        this.cascadeParticleAmountMultiplier = builder.defineInRange("cascade particles", 1.0, 0.0, 100.0);
        builder.pop();
        builder.push("Water Effects");
        builder.comment("Defines Ripple Particle Amount Display On Calm Water.\nZero Means No Ripple Particles.");
        this.rainRippleAbundance = builder.defineInRange("ripple abundance", 1, 0, 256);
        builder.comment("Defines Splash Particle Display Amount Around Flowing Water.\nZero Means No Splash Particles.");
        this.flowingWaterSplashiesAbundance = builder.defineInRange("splash abundance", 50, 0, 65536);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)builder.build());
    }
}

