/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block.properties;

import javax.annotation.Nonnull;
import net.minecraft.util.StringRepresentable;
import net.valhelsia.valhelsia_furniture.common.block.properties.CurtainPart;

public enum ClosedCurtainPart implements StringRepresentable,
CurtainPart
{
    SINGLE("single", CurtainPart.ModelType.CURTAIN, "curtain", "curtain"),
    TOP("top", CurtainPart.ModelType.CURTAIN, "curtain", "middle"),
    MIDDLE("middle", CurtainPart.ModelType.CURTAIN_FULL, "middle", "middle"),
    BOTTOM("bottom", CurtainPart.ModelType.CURTAIN_FULL, "middle", "curtain");

    private final String name;
    private final CurtainPart.ModelType modelType;
    private final String topTexture;
    private final String bottomTexture;

    private ClosedCurtainPart(String name, CurtainPart.ModelType modelType, String topTexture, String bottomTexture) {
        this.name = name;
        this.modelType = modelType;
        this.topTexture = topTexture;
        this.bottomTexture = bottomTexture;
    }

    @Nonnull
    public String m_7912_() {
        return this.name;
    }

    public static ClosedCurtainPart getTypeForConnections(boolean connectUp, boolean connectDown) {
        if (connectUp && connectDown) {
            return MIDDLE;
        }
        if (connectUp) {
            return BOTTOM;
        }
        if (connectDown) {
            return TOP;
        }
        return SINGLE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSingle() {
        return this == SINGLE;
    }

    @Override
    public boolean isBottomOrSingle() {
        return this == BOTTOM || this == SINGLE;
    }

    @Override
    public boolean isTopOrSingle() {
        return this == TOP || this == SINGLE;
    }

    @Override
    public boolean isSingleRow() {
        return true;
    }

    @Override
    public String getTopTexture() {
        return this.topTexture;
    }

    @Override
    public String getBottomTexture() {
        return this.bottomTexture;
    }

    @Override
    public CurtainPart.ModelType getModelType() {
        return this.modelType;
    }
}

