/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;

public class TableBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final int MAX_LENGTH = 5;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    private static final BooleanProperty ROTATED = ModBlockStateProperties.ROTATED;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumMap<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (EnumMap)Util.m_137469_(new EnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
    });
    private static final VoxelShape TOP_SHAPE = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> TWO_LEGS_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Shapes.m_83124_((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)}));
    private static final Map<Direction, VoxelShape> ONE_LEG_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Shapes.m_83110_((VoxelShape)TOP_SHAPE, (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)));
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0)});
    private final String baseName;
    @Nullable
    private final DyeColor color;

    public TableBlock(String baseName, BlockBehaviour.Properties properties) {
        this(baseName, null, properties);
    }

    public TableBlock(String baseName, @Nullable DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROTATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.baseName = baseName;
        this.color = color;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        ArrayList<Direction> connectedDirections = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            if (direction.m_122434_() == Direction.Axis.Y || !((Boolean)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            connectedDirections.add(direction);
        }
        if (connectedDirections.size() >= 3 || connectedDirections.size() == 2 && connectedDirections.get(0) == ((Direction)connectedDirections.get(1)).m_122424_()) {
            return TOP_SHAPE;
        }
        if (connectedDirections.size() == 1) {
            return TWO_LEGS_SHAPES.get(connectedDirections.get(0));
        }
        if (connectedDirections.size() == 2) {
            boolean flag = ((Direction)connectedDirections.get(0)).m_122427_() == connectedDirections.get(1);
            return flag ? ONE_LEG_SHAPES.get(connectedDirections.get(0)) : ONE_LEG_SHAPES.get(connectedDirections.get(1));
        }
        return SHAPE;
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        boolean rotated = context.m_8125_().m_122434_() == Direction.Axis.X;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATED, (Comparable)Boolean.valueOf(rotated))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction.m_122434_() == Direction.Axis.Y) {
            return state;
        }
        BooleanProperty property = PROPERTY_BY_DIRECTION.get(direction);
        BooleanProperty oppositeProperty = PROPERTY_BY_DIRECTION.get(direction.m_122424_());
        if (neighborState.m_60734_() instanceof TableBlock) {
            if (((Boolean)neighborState.m_61143_((Property)oppositeProperty)).booleanValue() && !((Boolean)state.m_61143_((Property)property)).booleanValue()) {
                return (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(true));
            }
            if (!((Boolean)neighborState.m_61143_((Property)oppositeProperty)).booleanValue() && ((Boolean)state.m_61143_((Property)property)).booleanValue()) {
                return (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(false));
            }
        } else if (((Boolean)state.m_61143_((Property)property)).booleanValue()) {
            return (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(false));
        }
        if (this.isValidTable(neighborState) && !((Boolean)state.m_61143_((Property)property)).booleanValue()) {
            this.tryConnect(direction, currentPos, level);
        }
        return state;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        for (Direction direction : Direction.values()) {
            if (direction.m_122434_() == Direction.Axis.Y || !((Boolean)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            this.trySplit(direction, pos, (LevelAccessor)level);
            break;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    private void tryConnect(Direction direction, BlockPos pos, LevelAccessor level) {
        BlockState offsetState;
        BlockState state;
        BlockPos.MutableBlockPos mutable;
        int j;
        BlockState state2;
        BlockState state3;
        int tableLength;
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        for (tableLength = 1; tableLength < 5 && (state3 = level.m_8055_(pos.m_5484_(direction.m_122424_(), tableLength))).m_60734_() instanceof TableBlock && ((Boolean)state3.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue(); ++tableLength) {
        }
        int otherTableLength = 1;
        for (int j2 = 2; j2 < 5 && (state2 = level.m_8055_(pos.m_5484_(direction, j2))).m_60734_() instanceof TableBlock && ((Boolean)state2.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122424_()))).booleanValue(); ++j2) {
            ++otherTableLength;
        }
        if (tableLength + otherTableLength > 5) {
            return;
        }
        boolean flag = false;
        BlockPos offsetPos = pos.m_121945_(direction);
        if (!this.isSameRotation(level.m_8055_(pos), level.m_8055_(offsetPos))) {
            return;
        }
        list.add(offsetPos);
        if (level.m_8055_(offsetPos).m_60734_() instanceof TableBlock) {
            flag = (Boolean)level.m_8055_(offsetPos).m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122427_()));
        }
        for (j = 1; j < 5; ++j) {
            mutable = pos.m_122032_().m_122175_(direction.m_122427_(), j);
            state = level.m_8055_((BlockPos)mutable);
            offsetState = level.m_8055_((BlockPos)mutable.m_122173_(direction));
            if (!this.isValidTable(state) || this.isValidTable(state) && !((Boolean)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122428_()))).booleanValue() || !this.isSameRotation(level.m_8055_(pos), state)) {
                if (!this.isValidTable(offsetState) || !flag) break;
                return;
            }
            if (!this.isValidTable(offsetState) || this.isValidTable(offsetState) && !((Boolean)offsetState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122428_()))).booleanValue() || !this.isSameRotation(level.m_8055_(pos), offsetState)) {
                return;
            }
            flag = this.isValidTable(offsetState) ? (Boolean)offsetState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122427_())) : false;
            list.add(mutable);
            ++i;
        }
        flag = level.m_8055_(offsetPos).m_60734_() instanceof TableBlock ? (Boolean)level.m_8055_(offsetPos).m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122428_())) : false;
        for (j = 1; j < 5; ++j) {
            mutable = pos.m_122032_().m_122175_(direction.m_122428_(), j);
            state = level.m_8055_((BlockPos)mutable);
            offsetState = level.m_8055_((BlockPos)mutable.m_122173_(direction));
            if (!this.isValidTable(state) || this.isValidTable(state) && !((Boolean)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122427_()))).booleanValue() || !this.isSameRotation(level.m_8055_(pos), state)) {
                if (!this.isValidTable(offsetState) || !flag) break;
                return;
            }
            if (!this.isValidTable(offsetState) || this.isValidTable(offsetState) && !((Boolean)offsetState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122427_()))).booleanValue() || !this.isSameRotation(level.m_8055_(pos), offsetState)) {
                return;
            }
            flag = this.isValidTable(offsetState) ? (Boolean)offsetState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122428_())) : false;
            list.add(mutable);
            ++i;
        }
        if (i >= 5) {
            return;
        }
        list.forEach(tablePos -> level.m_7731_(tablePos, (BlockState)level.m_8055_(tablePos).m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122424_()), (Comparable)Boolean.valueOf(true)), 3));
    }

    private void trySplit(Direction direction, BlockPos pos, LevelAccessor level) {
        BlockPos.MutableBlockPos mutable;
        BlockState offsetState;
        int j;
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (j = 1; j < 5 && this.isValidTable(offsetState = level.m_8055_((BlockPos)(mutable = pos.m_122032_().m_122175_(direction.m_122427_(), j)))) && ((Boolean)offsetState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122428_()))).booleanValue(); ++j) {
            if (!((Boolean)offsetState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            list.add(mutable.m_7949_());
        }
        for (j = 1; j < 5 && this.isValidTable(offsetState = level.m_8055_((BlockPos)(mutable = pos.m_122032_().m_122175_(direction.m_122428_(), j)))) && ((Boolean)offsetState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122427_()))).booleanValue(); ++j) {
            if (!((Boolean)offsetState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            list.add(mutable.m_7949_());
        }
        list.forEach(tablePos -> {
            BlockState state = level.m_8055_(tablePos);
            boolean rotated = (Boolean)state.m_61143_((Property)ROTATED);
            level.m_7731_(tablePos, Blocks.f_50016_.m_49966_(), 3);
            level.m_7731_(tablePos, (BlockState)state.m_60734_().m_49966_().m_61124_((Property)ROTATED, (Comparable)Boolean.valueOf(rotated)), 3);
        });
    }

    public boolean isValidTable(BlockState state) {
        TableBlock table;
        Block block = state.m_60734_();
        return block instanceof TableBlock && (table = (TableBlock)block).getBaseName().equals(this.getBaseName());
    }

    public boolean isSameRotation(BlockState state1, BlockState state2) {
        if (!this.isValidTable(state1) || !this.isValidTable(state2)) {
            return false;
        }
        return state1.m_61143_((Property)ROTATED) == state2.m_61143_((Property)ROTATED);
    }

    @Nonnull
    public String m_7705_() {
        return "block.valhelsia_furniture." + this.baseName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (this.color != null) {
            tooltip.add((Component)Component.m_237115_((String)("tooltip.valhelsia_furniture." + this.color + "_tablecloth")).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Nonnull
    public BlockState m_6843_(@Nonnull BlockState state, @Nonnull Rotation rotation) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (((Boolean)state.m_61143_((Property)entry.getValue())).booleanValue()) {
                directions.add(rotation.m_55954_(entry.getKey()));
            }
            state = (BlockState)state.m_61124_((Property)entry.getValue(), (Comparable)Boolean.valueOf(false));
        }
        for (Direction direction : directions) {
            state = (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Nonnull
    public BlockState m_6943_(@Nonnull BlockState state, @Nonnull Mirror mirror) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (((Boolean)state.m_61143_((Property)entry.getValue())).booleanValue()) {
                directions.add(mirror.m_54848_(entry.getKey()));
            }
            state = (BlockState)state.m_61124_((Property)entry.getValue(), (Comparable)Boolean.valueOf(false));
        }
        for (Direction direction : directions) {
            state = (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, ROTATED, WATERLOGGED});
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }
}

