/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_furniture.common.block.SeatableBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import net.valhelsia.valhelsia_furniture.common.entity.SeatEntity;

public class StoolBlock
extends Block
implements SimpleWaterloggedBlock,
SeatableBlock {
    public static final BooleanProperty ROTATED = ModBlockStateProperties.ROTATED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0), (VoxelShape)Block.m_49796_((double)3.0, (double)7.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0));
    private static final VoxelShape UPHOLSTERED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0), (VoxelShape)Block.m_49796_((double)3.0, (double)7.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0));
    private final String baseName;
    @Nullable
    private final DyeColor color;

    public StoolBlock(String baseName, BlockBehaviour.Properties properties) {
        this(baseName, null, properties);
    }

    public StoolBlock(String baseName, @Nullable DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ROTATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.baseName = baseName;
        this.color = color;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.getColor() != null ? UPHOLSTERED_SHAPE : SHAPE;
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)ROTATED, (Comparable)Boolean.valueOf((Mth.m_14107_((double)((double)((180.0f + context.m_7074_()) * 8.0f / 360.0f) + 0.5)) & 7) % 2 != 0));
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Nonnull
    public String m_7705_() {
        return "block.valhelsia_furniture." + this.baseName + "_stool";
    }

    public String getBaseName() {
        return this.baseName;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (!level.m_5776_() && !player.m_6144_()) {
            this.sitDown(level, pos, (Entity)player);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_7892_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (!(entity instanceof Player)) {
            this.sitDown(level, pos, entity);
        }
    }

    private void sitDown(Level level, BlockPos pos, Entity entity) {
        if (!this.isEntitySitting(level, pos)) {
            SeatEntity chair = new SeatEntity(pos, 0.3, level);
            level.m_7967_((Entity)chair);
            entity.m_20329_((Entity)chair);
            level.m_46717_(pos, level.m_8055_(pos).m_60734_());
        }
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        if ((level.m_46753_(pos) || level.m_46753_(pos.m_7494_())) && this.isEntitySitting(level, pos)) {
            ((SeatEntity)((Object)level.m_45976_(SeatEntity.class, new AABB(pos)).get(0))).m_146870_();
            level.m_46717_(pos, level.m_8055_(pos).m_60734_());
        }
    }

    private boolean isEntitySitting(Level level, BlockPos pos) {
        return !level.m_45976_(SeatEntity.class, new AABB(pos)).isEmpty();
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6782_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos) {
        return this.isEntitySitting(level, pos) ? 15 : 0;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (this.color != null) {
            tooltip.add((Component)Component.m_237115_((String)("tooltip.valhelsia_furniture." + this.color + "_wool_seat")).m_130940_(ChatFormatting.GRAY));
        }
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, ROTATED});
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    @Override
    public SeatEntity.EjectType getEjectType() {
        return SeatEntity.EjectType.ENTITY_HEAD_ROTATION;
    }
}

