/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_furniture.common.block.AbstractCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.OpenCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.ClosedCurtainPart;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import net.valhelsia.valhelsia_furniture.common.block.properties.OpenCurtainPart;

public class ClosedCurtainBlock
extends AbstractCurtainBlock<ClosedCurtainPart> {
    public static EnumProperty<ClosedCurtainPart> PART = ModBlockStateProperties.CLOSED_CURTAIN_PART;

    public ClosedCurtainBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(PART, (Comparable)((Object)ClosedCurtainPart.SINGLE))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    protected void updateOpen(BlockState state, Level level, BlockPos pos) {
        Direction base = (Direction)state.m_61143_((Property)FACING);
        Direction left = base.m_122427_();
        Direction right = base.m_122428_();
        BlockPos topPos = this.getTopBlock((LevelAccessor)level, pos);
        int length = this.getCurtainLength((LevelAccessor)level, topPos);
        boolean leftConnected = this.isConnected((LevelAccessor)level, state, topPos, left, length);
        boolean rightConnected = this.isConnected((LevelAccessor)level, state, topPos, right, length);
        this.openRow(level, topPos, length, leftConnected, rightConnected);
        if (leftConnected) {
            this.openRows(level, state, topPos.m_122032_(), left, base, length);
        }
        if (rightConnected) {
            this.openRows(level, state, topPos.m_122032_(), right, base, length);
        }
    }

    @Override
    protected ClosedCurtainPart getPart(BlockState state) {
        return (ClosedCurtainPart)((Object)state.m_61143_(PART));
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        ClosedCurtainPart part = (ClosedCurtainPart)((Object)state.m_61143_(PART));
        return part == ClosedCurtainPart.SINGLE || part == ClosedCurtainPart.TOP ? (VoxelShape)TOP_SHAPES.get(facing) : (VoxelShape)SHAPES.get(facing);
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        ClosedCurtainPart part = (ClosedCurtainPart)((Object)state.m_61143_(PART));
        return part == ClosedCurtainPart.SINGLE || part == ClosedCurtainPart.TOP ? (VoxelShape)BRACKET_SHAPES.get(state.m_61143_((Property)FACING)) : Shapes.m_83040_();
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockPos above = pos.m_7494_();
        BlockPos below = pos.m_7495_();
        BlockState aboveState = level.m_8055_(above);
        BlockState belowState = level.m_8055_(below);
        Direction facing = context.m_8125_().m_122424_();
        boolean powered = level.m_46753_(pos) || level.m_46753_(pos.m_7494_());
        BlockState state = powered ? (BlockState)this.getOpenBlock().m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)) : this.m_49966_();
        state = (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)this.connect(aboveState, belowState, facing)))).m_61124_((Property)FACING, (Comparable)facing);
        if (!powered) {
            this.updateAboveAndBelow(level, state, above, below, facing);
        }
        return state;
    }

    @Override
    protected void openRow(Level level, BlockPos topPos, int length, boolean leftConnected, boolean rightConnected) {
        OpenCurtainBlock block = this.getOpenBlock();
        for (int i = 0; i < length; ++i) {
            BlockState state = level.m_8055_(topPos.m_6625_(i));
            ClosedCurtainPart part = (ClosedCurtainPart)((Object)state.m_61143_(PART));
            OpenCurtainPart newPart = OpenCurtainPart.SINGLE;
            if (length == 1) {
                if (leftConnected && rightConnected) {
                    newPart = OpenCurtainPart.TOP;
                }
                if (leftConnected && !rightConnected) {
                    newPart = OpenCurtainPart.RIGHT;
                }
                if (rightConnected && !leftConnected) {
                    newPart = OpenCurtainPart.LEFT;
                }
            } else {
                if (leftConnected && rightConnected && (part == ClosedCurtainPart.MIDDLE || part == ClosedCurtainPart.BOTTOM)) {
                    newPart = OpenCurtainPart.MIDDLE;
                }
                if (part == ClosedCurtainPart.TOP) {
                    newPart = leftConnected && rightConnected ? OpenCurtainPart.TOP : (leftConnected ? OpenCurtainPart.RIGHT_SIDE_TOP : (rightConnected ? OpenCurtainPart.LEFT_SIDE_TOP : OpenCurtainPart.SINGLE_TOP));
                } else if (part == ClosedCurtainPart.MIDDLE) {
                    if (leftConnected && !rightConnected) {
                        newPart = OpenCurtainPart.RIGHT_SIDE_MIDDLE;
                    } else if (!leftConnected && rightConnected) {
                        newPart = OpenCurtainPart.LEFT_SIDE_MIDDLE;
                    } else if (!leftConnected) {
                        newPart = OpenCurtainPart.SINGLE_MIDDLE;
                    }
                } else if (part == ClosedCurtainPart.BOTTOM) {
                    if (leftConnected && !rightConnected) {
                        newPart = OpenCurtainPart.RIGHT_SIDE_BOTTOM;
                    } else if (!leftConnected && rightConnected) {
                        newPart = OpenCurtainPart.LEFT_SIDE_BOTTOM;
                    } else if (!leftConnected) {
                        newPart = OpenCurtainPart.SINGLE_BOTTOM;
                    }
                }
            }
            level.m_46597_(topPos.m_6625_(i), (BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_(OpenCurtainBlock.PART, (Comparable)((Object)newPart))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)POWERED, (Comparable)((Boolean)state.m_61143_((Property)POWERED))));
        }
    }

    @Override
    protected boolean isOpen() {
        return false;
    }

    @Override
    protected ClosedCurtainPart connect(BlockState aState, BlockState bState, Direction facing) {
        return ClosedCurtainPart.getTypeForConnections(aState.m_60734_() instanceof ClosedCurtainBlock && aState.m_61143_((Property)FACING) == facing, bState.m_60734_() instanceof ClosedCurtainBlock && bState.m_61143_((Property)FACING) == facing);
    }

    private void updateAboveAndBelow(Level level, BlockState state, BlockPos above, BlockPos below, Direction facing) {
        BlockState aboveState = level.m_8055_(above);
        BlockState belowState = level.m_8055_(below);
        if (aboveState.m_60713_((Block)this)) {
            level.m_46597_(above, (BlockState)aboveState.m_61124_(PART, (Comparable)((Object)this.connect(level.m_8055_(above.m_7494_()), state, facing))));
        }
        if (belowState.m_60713_((Block)this)) {
            level.m_46597_(below, (BlockState)belowState.m_61124_(PART, (Comparable)((Object)this.connect(state, level.m_8055_(below.m_7495_()), facing))));
        }
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!(newState.m_60734_() instanceof AbstractCurtainBlock)) {
            this.updateAboveAndBelow(level, newState, pos.m_7494_(), pos.m_7495_(), (Direction)state.m_61143_((Property)FACING));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, POWERED, FACING});
    }
}

