/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.ClosedCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.OpenCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.CurtainPart;
import net.valhelsia.valhelsia_furniture.common.block.properties.OpenCurtainPart;
import net.valhelsia.valhelsia_furniture.core.registry.ModBlocks;

public abstract class AbstractCurtainBlock<T extends CurtainPart>
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final VoxelShape BRACKET_SHAPE = Block.m_49796_((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    public static final Map<Direction, VoxelShape> TOP_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)BRACKET_SHAPE));
    public static final Map<Direction, VoxelShape> SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)SHAPE);
    public static final Map<Direction, VoxelShape> BRACKET_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)BRACKET_SHAPE);
    private final DyeColor color;

    public AbstractCurtainBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
    }

    @Nonnull
    public VoxelShape m_7947_(@Nonnull BlockState state, @Nonnull BlockGetter blockGetter, @Nonnull BlockPos pos) {
        return Shapes.m_83040_();
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.CONSUME;
        }
        this.updateOpen(state, level, pos);
        return InteractionResult.SUCCESS;
    }

    protected abstract void updateOpen(BlockState var1, Level var2, BlockPos var3);

    protected abstract T getPart(BlockState var1);

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        boolean powered = level.m_46753_(pos);
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() != level.m_46753_(pos)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)));
            if (powered) {
                this.updateOpen(state, level, pos);
            }
        }
    }

    protected BlockPos getTopBlock(LevelAccessor level, BlockPos currentPos) {
        BlockPos.MutableBlockPos pos = currentPos.m_122032_();
        BlockState state = level.m_8055_(pos.m_7494_());
        while (state.m_60713_((Block)this) && !this.getPart(state).isBottomOrSingle()) {
            pos.m_122173_(Direction.UP);
            state = level.m_8055_(pos.m_7494_());
        }
        return pos.m_7949_();
    }

    protected void openRows(Level level, BlockState state, BlockPos.MutableBlockPos topPos, Direction direction, Direction baseDirection, int length) {
        boolean leftDirection = baseDirection.m_122427_() == direction;
        while (true) {
            topPos.m_122173_(direction);
            if (!this.isConnected((LevelAccessor)level, state, (BlockPos)topPos, length)) break;
            boolean leftConnected = !leftDirection || this.isConnected((LevelAccessor)level, state, (BlockPos)topPos, baseDirection.m_122427_(), length);
            boolean rightConnected = leftDirection || this.isConnected((LevelAccessor)level, state, (BlockPos)topPos, baseDirection.m_122428_(), length);
            this.openRow(level, (BlockPos)topPos, length, leftConnected, rightConnected);
        }
    }

    protected abstract void openRow(Level var1, BlockPos var2, int var3, boolean var4, boolean var5);

    protected boolean isConnected(LevelAccessor level, BlockState state, BlockPos pos, Direction direction, int length) {
        return this.isConnected(level, state, pos.m_121945_(direction), length);
    }

    private boolean isConnected(LevelAccessor level, BlockState state, BlockPos neighborPos, int length) {
        BlockState neighborState = level.m_8055_(neighborPos);
        if (!this.shouldUpdateTogether(level, state, neighborPos, length)) {
            return false;
        }
        T part = this.getPart(neighborState);
        return part.isTopOrSingle() || this.bothSingle(state, neighborState) || part == OpenCurtainPart.LEFT || part == OpenCurtainPart.RIGHT;
    }

    private boolean shouldUpdateTogether(LevelAccessor level, BlockState state, BlockPos neighborPos, int length) {
        BlockState neighborState = level.m_8055_(neighborPos);
        if (!this.belongTogether(state, neighborState)) {
            return false;
        }
        if (this.isOpen() && (this.getPart(state).isSingleRow() || this.getPart(neighborState).isSingleRow())) {
            return false;
        }
        return this.getCurtainLength(level, neighborPos) == length;
    }

    protected abstract boolean isOpen();

    private boolean belongTogether(BlockState state, BlockState neighborState) {
        return neighborState.m_60713_((Block)this) && this.hasSameFacing(state, neighborState);
    }

    private boolean bothSingle(BlockState state, BlockState neighborState) {
        return this.getPart(state).isSingle() && this.getPart(neighborState).isSingle();
    }

    private boolean hasSameFacing(BlockState state, BlockState neighborState) {
        return state.m_61143_((Property)FACING) == neighborState.m_61143_((Property)FACING);
    }

    protected int getCurtainLength(LevelAccessor level, BlockPos topPos) {
        BlockPos.MutableBlockPos pos = topPos.m_122032_().m_122173_(Direction.DOWN);
        BlockState state = level.m_8055_((BlockPos)pos);
        int length = 1;
        while (state.m_60713_((Block)this) && !this.getPart(state).isTopOrSingle()) {
            state = level.m_8055_((BlockPos)pos.m_122173_(Direction.DOWN));
            ++length;
        }
        return length;
    }

    protected abstract T connect(BlockState var1, BlockState var2, Direction var3);

    public ClosedCurtainBlock getClosedBlock() {
        return (ClosedCurtainBlock)((Object)((RegistryObject)ModBlocks.CURTAINS.get(this.getColor()).getFirst()).get());
    }

    public OpenCurtainBlock getOpenBlock() {
        return (OpenCurtainBlock)((Object)((RegistryObject)ModBlocks.CURTAINS.get(this.getColor()).getSecond()).get());
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

