/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.capability.counter;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class SimpleCounter {
    private final ResourceLocation name;
    private int value;
    private boolean active = true;

    public SimpleCounter(ResourceLocation name) {
        this.name = name;
        this.value = 0;
    }

    public SimpleCounter(ResourceLocation name, int value) {
        this.name = name;
        this.value = value;
    }

    public SimpleCounter(ResourceLocation name, int value, boolean active) {
        this.name = name;
        this.value = value;
        this.active = active;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int timer) {
        this.value = timer;
    }

    public void tick() {
        this.tick(new CompoundTag());
    }

    public void tick(CompoundTag tag) {
        if (this.isActive()) {
            this.increase();
        }
    }

    public void increase() {
        ++this.value;
    }

    public void decrease() {
        --this.value;
    }

    public void resetTimer() {
        this.value = 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void load(CompoundTag compound) {
        this.value = compound.m_128451_("value");
        this.active = compound.m_128441_("active") ? compound.m_128471_("active") : true;
    }

    public CompoundTag save(CompoundTag compound) {
        compound.m_128405_("value", this.value);
        if (!this.isActive()) {
            compound.m_128379_("active", this.active);
        }
        return compound;
    }
}

