/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.ryoamiclights.api;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.ryoamiclights.RyoamicLights;
import org.thinkingstudio.ryoamiclights.accessor.DynamicLightHandlerHolder;
import org.thinkingstudio.ryoamiclights.api.DynamicLightHandler;
import org.thinkingstudio.ryoamiclights.config.LightSourceSettingEntry;

public final class DynamicLightHandlers {
    private DynamicLightHandlers() {
        throw new UnsupportedOperationException("DynamicLightHandlers only contains static definitions.");
    }

    public static void registerDefaultHandlers() {
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.f_20551_, DynamicLightHandler.makeHandler(blaze -> 10, blaze -> true));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.f_20558_, DynamicLightHandler.makeCreeperEntityHandler(null));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.f_20566_, (T entity) -> {
            int luminance = 0;
            if (entity.m_32530_() != null) {
                luminance = entity.m_32530_().m_60791_();
            }
            return luminance;
        });
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.f_20461_, (T entity) -> RyoamicLights.getLuminanceFromItemStack(entity.m_32055_(), entity.m_5842_()));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.f_20462_, (T entity) -> {
            Level world = entity.m_9236_();
            return RyoamicLights.getLuminanceFromItemStack(entity.m_31822_(), !world.m_6425_(entity.m_20183_()).m_76178_());
        });
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.f_147033_, (T entity) -> {
            Level world = entity.m_9236_();
            return Math.max(14, RyoamicLights.getLuminanceFromItemStack(entity.m_31822_(), !world.m_6425_(entity.m_20183_()).m_76178_()));
        });
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.f_20468_, (T entity) -> (double)entity.f_33584_ > 0.6 ? 11 : 8);
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.f_20478_, (T entity) -> 8);
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.f_147034_, (T entity) -> (int)Mth.m_144920_((float)0.0f, (float)12.0f, (float)(1.0f - (float)entity.m_147128_() / 10.0f)));
    }

    public static <T extends Entity> void registerDynamicLightHandler(EntityType<T> type, DynamicLightHandler<T> handler) {
        DynamicLightHandlers.register((DynamicLightHandlerHolder)type, handler);
    }

    public static <T extends BlockEntity> void registerDynamicLightHandler(BlockEntityType<T> type, DynamicLightHandler<T> handler) {
        DynamicLightHandlers.register((DynamicLightHandlerHolder)type, handler);
    }

    private static <T> void register(DynamicLightHandlerHolder<T> holder, DynamicLightHandler<T> handler) {
        DynamicLightHandler registeredHandler = holder.ryoamiclights$getDynamicLightHandler();
        if (registeredHandler != null) {
            DynamicLightHandler<Object> newHandler = entity -> Math.max(registeredHandler.getLuminance(entity), handler.getLuminance(entity));
            holder.ryoamiclights$setDynamicLightHandler(newHandler);
        } else {
            holder.ryoamiclights$setDynamicLightHandler(handler);
        }
    }

    @Nullable
    public static <T extends Entity> DynamicLightHandler<T> getDynamicLightHandler(EntityType<T> type) {
        return DynamicLightHandlerHolder.cast(type).ryoamiclights$getDynamicLightHandler();
    }

    @Nullable
    public static <T extends BlockEntity> DynamicLightHandler<T> getDynamicLightHandler(BlockEntityType<T> type) {
        return DynamicLightHandlerHolder.cast(type).ryoamiclights$getDynamicLightHandler();
    }

    public static <T extends Entity> boolean canLightUp(T entity) {
        if (entity == Minecraft.m_91087_().f_91074_ && !((Boolean)RyoamicLights.get().config.getSelfLightSource().get()).booleanValue()) {
            return false;
        }
        LightSourceSettingEntry setting = DynamicLightHandlerHolder.cast(entity.m_6095_()).ryoamiclights$getSetting();
        return setting != null && (Boolean)setting.get() != false;
    }

    public static <T extends BlockEntity> boolean canLightUp(T entity) {
        LightSourceSettingEntry setting = DynamicLightHandlerHolder.cast(entity.m_58903_()).ryoamiclights$getSetting();
        return setting != null && (Boolean)setting.get() != false;
    }

    public static <T extends Entity> int getLuminanceFrom(T entity) {
        if (!((Boolean)RyoamicLights.get().config.getEntitiesLightSource().get()).booleanValue()) {
            return 0;
        }
        if (entity == Minecraft.m_91087_().f_91074_ && !((Boolean)RyoamicLights.get().config.getSelfLightSource().get()).booleanValue()) {
            return 0;
        }
        DynamicLightHandler<T> handler = DynamicLightHandlers.getDynamicLightHandler(entity.m_6095_());
        if (handler == null) {
            return 0;
        }
        if (!DynamicLightHandlers.canLightUp(entity)) {
            return 0;
        }
        if (handler.isWaterSensitive(entity) && !entity.m_9236_().m_6425_(new BlockPos(entity.m_20185_(), entity.m_20188_(), entity.m_20189_())).m_76178_()) {
            return 0;
        }
        return handler.getLuminance(entity);
    }

    public static <T extends BlockEntity> int getLuminanceFrom(T entity) {
        if (!((Boolean)RyoamicLights.get().config.getBlockEntitiesLightSource().get()).booleanValue()) {
            return 0;
        }
        DynamicLightHandler<T> handler = DynamicLightHandlers.getDynamicLightHandler(entity.m_58903_());
        if (handler == null) {
            return 0;
        }
        if (!DynamicLightHandlers.canLightUp(entity)) {
            return 0;
        }
        if (handler.isWaterSensitive(entity) && entity.m_58904_() != null && !entity.m_58904_().m_6425_(entity.m_58899_()).m_76178_()) {
            return 0;
        }
        return handler.getLuminance(entity);
    }
}

