/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.features;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;

public class UpdateShaderConfig {
    public static void updateShaderTxtConfigFile(boolean styleUnbound, boolean styleReimagined) {
        block30: {
            try (DirectoryStream<Path> oldConfigTextStream = Files.newDirectoryStream(EuphoriaPatcher.shaderpacks, path -> UpdateShaderConfig.isConfigFile(path, true));){
                Path oldShaderConfigFilePath = UpdateShaderConfig.findShaderConfigFile(oldConfigTextStream, true);
                if (oldShaderConfigFilePath != null) {
                    UpdateShaderConfig.doConfigFileCopy(oldShaderConfigFilePath, true, styleUnbound, styleReimagined);
                    break block30;
                }
                try (DirectoryStream<Path> baseShaderConfigTextStream = Files.newDirectoryStream(EuphoriaPatcher.shaderpacks, path -> UpdateShaderConfig.isConfigFile(path, false));){
                    Path baseShaderConfigFilePath = UpdateShaderConfig.findShaderConfigFile(baseShaderConfigTextStream, true);
                    if (baseShaderConfigFilePath != null) {
                        UpdateShaderConfig.doConfigFileCopy(baseShaderConfigFilePath, false, styleUnbound, styleReimagined);
                    }
                }
                catch (IOException e) {
                    EuphoriaPatcher.log(3, 0, "Error reading shaderpacks directory: " + e.getMessage());
                }
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, 0, "Error reading shaderpacks directory: " + e.getMessage());
            }
        }
    }

    private static void doConfigFileCopy(Path configFilePath, boolean containsPatchName, boolean styleUnbound, boolean styleReimagined) {
        String style = styleUnbound ? "Unbound" : "Reimagined";
        String newName = "Complementary" + style + "_r5.3" + " + " + "EuphoriaPatches" + "_1.4.3" + ".txt";
        try {
            Files.copy(configFilePath, configFilePath.resolveSibling(newName), new CopyOption[0]);
            EuphoriaPatcher.log(0, "Successfully updated shader config file to the latest version!");
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, 0, "Could not rename the config file: " + e.getMessage());
        }
        if (styleUnbound && styleReimagined) {
            EuphoriaPatcher.log(0, "Both shader styles detected!");
            try (DirectoryStream<Path> latestConfigTextStream = Files.newDirectoryStream(EuphoriaPatcher.shaderpacks, path -> UpdateShaderConfig.isConfigFile(path, containsPatchName));){
                Path latestShaderConfigFilePath = UpdateShaderConfig.findShaderConfigFile(latestConfigTextStream, false);
                if (latestShaderConfigFilePath != null) {
                    style = latestShaderConfigFilePath.toString().contains("Unbound") ? "Reimagined" : "Unbound";
                    newName = "Complementary" + style + "_r5.3" + " + " + "EuphoriaPatches" + "_1.4.3" + ".txt";
                    try {
                        Files.copy(latestShaderConfigFilePath, latestShaderConfigFilePath.resolveSibling(newName), new CopyOption[0]);
                        EuphoriaPatcher.log(0, "Successfully copied shader config file and renamed it!");
                    }
                    catch (IOException e) {
                        EuphoriaPatcher.log(3, 0, "Could not copy and rename the config file: " + e.getMessage());
                    }
                }
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, 0, "Error reading shaderpacks directory: " + e.getMessage());
            }
        }
    }

    private static boolean isConfigFile(Path path, boolean containsPatchName) {
        String nameText = path.getFileName().toString();
        return containsPatchName ? nameText.matches(".*?Comp(?:lementary)?.*?(?:Reimagined|Unbound)?.*") && nameText.endsWith(".txt") && (nameText.contains("EuphoriaPatches") || nameText.contains(" + EP_")) : nameText.matches(".*Complementary.*(Reimagined|Unbound).*") && nameText.endsWith(".txt");
    }

    private static Path findShaderConfigFile(DirectoryStream<Path> textStream, boolean searchOldEuphoriaConfigs) {
        ArrayList<Path> euphoriaFiles = new ArrayList<Path>();
        ArrayList<Path> baseFiles = new ArrayList<Path>();
        for (Path potentialTextFile : textStream) {
            String name = potentialTextFile.getFileName().toString();
            if (!name.endsWith(".txt")) continue;
            if (name.contains("EuphoriaPatches") || name.contains("EP_")) {
                euphoriaFiles.add(potentialTextFile);
                continue;
            }
            baseFiles.add(potentialTextFile);
        }
        if (!euphoriaFiles.isEmpty()) {
            euphoriaFiles.sort((p1, p2) -> UpdateShaderConfig.compareConfigFileVersions(UpdateShaderConfig.getConfigFileVersion(p1), UpdateShaderConfig.getConfigFileVersion(p2)));
            Path latestEuphoriaConfig = (Path)euphoriaFiles.get(euphoriaFiles.size() - 1);
            String latestName = latestEuphoriaConfig.getFileName().toString();
            if (searchOldEuphoriaConfigs) {
                if (!latestName.contains("_1.4.3") || latestName.contains("dev")) {
                    return latestEuphoriaConfig;
                }
            } else {
                return latestEuphoriaConfig;
            }
        }
        if (!baseFiles.isEmpty()) {
            baseFiles.sort((p1, p2) -> UpdateShaderConfig.compareConfigFileVersions(UpdateShaderConfig.getConfigFileVersion(p1), UpdateShaderConfig.getConfigFileVersion(p2)));
            return (Path)baseFiles.get(baseFiles.size() - 1);
        }
        return null;
    }

    private static String getConfigFileVersion(Path path) {
        String name = path.getFileName().toString();
        Pattern pattern = Pattern.compile("(?:[a-zA-Z_]+)?[rdp]?(\\d+(?:\\.\\d+)*)(?:[rdp]\\d+)?(?: \\+ )?(?:EuphoriaPatches_|EP_)(\\d+(?:\\.\\d+)*(?:-dev\\d+)?)");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            String mainVersion = matcher.group(1);
            String patchVersion = matcher.group(2);
            if (patchVersion != null) {
                return patchVersion + "|" + mainVersion;
            }
            return "0|" + mainVersion;
        }
        return "0|0";
    }

    private static int compareConfigFileVersions(String v1, String v2) {
        String[] fullVersion2;
        String[] fullVersion1 = v1.split("\\|");
        int epCompare = UpdateShaderConfig.compareVersionParts(fullVersion1[0], (fullVersion2 = v2.split("\\|"))[0]);
        if (epCompare != 0) {
            return epCompare;
        }
        return UpdateShaderConfig.compareVersionParts(fullVersion1[1], fullVersion2[1]);
    }

    private static int compareVersionParts(String p1, String p2) {
        String[] parts1 = p1.split("[.\\-]");
        String[] parts2 = p2.split("[.\\-]");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            String part1 = i < parts1.length ? parts1[i] : "0";
            String part2 = i < parts2.length ? parts2[i] : "0";
            boolean isP1Dev = part1.contains("dev");
            boolean isP2Dev = part2.contains("dev");
            if (isP1Dev && isP2Dev) {
                String[] devParts1 = part1.split("dev");
                String[] devParts2 = part2.split("dev");
                EuphoriaPatcher.log(0, devParts1[1] + "  " + devParts2[1]);
                int mainCompare = Integer.compare(Integer.parseInt(devParts1[1]), Integer.parseInt(devParts2[1]));
                if (mainCompare != 0) {
                    return mainCompare;
                }
                return Integer.parseInt(devParts1[1]);
            }
            if (isP1Dev) {
                return -1;
            }
            if (isP2Dev) {
                return 1;
            }
            int compare = Integer.compare(Integer.parseInt(part1), Integer.parseInt(part2));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

