/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ArchiveUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extract(Path in, Path out) throws IOException, ArchiveException {
        Files.createDirectories(out, new FileAttribute[0]);
        try (ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(in, new OpenOption[0])));){
            ArchiveEntry entry;
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                OutputStream outputStream;
                block23: {
                    if (!archiveInputStream.canReadEntryData(entry)) continue;
                    Path targetFilePath = out.resolve(entry.getName()).normalize();
                    if (entry.isDirectory()) {
                        Files.createDirectories(targetFilePath, new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(targetFilePath.getParent(), new FileAttribute[0]);
                    outputStream = Files.newOutputStream(targetFilePath, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)archiveInputStream, (OutputStream)outputStream);
                        if (outputStream == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (outputStream == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    outputStream.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            outputStream.close();
                            throw throwable3;
                        }
                    }
                    try {
                        outputStream.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                outputStream.close();
            }
            return;
        }
    }

    public static void archive(Path sourceDir, Path archive) throws IOException {
        try (TarArchiveOutputStream tarOutputStream = new TarArchiveOutputStream(Files.newOutputStream(archive, new OpenOption[0]));){
            try (Stream<Path> fileStream = Files.walk(sourceDir, new FileVisitOption[0]);){
                fileStream.sorted(Comparator.comparing(Path::toUri)).forEach(filePath -> ArchiveUtils.addFileToArchive(tarOutputStream, sourceDir, filePath));
            }
            tarOutputStream.finish();
        }
    }

    private static void addFileToArchive(TarArchiveOutputStream tarOutputStream, Path sourceDir, Path filePath) {
        try {
            String fileName = sourceDir.relativize(filePath).toString().replace(File.separatorChar, '/');
            TarArchiveEntry tarEntry = new TarArchiveEntry(filePath.toFile(), fileName);
            tarEntry.setModTime(0L);
            tarEntry.setIds(0, 0);
            tarEntry.setNames("", "");
            tarOutputStream.putArchiveEntry((ArchiveEntry)tarEntry);
            if (Files.isRegularFile(filePath, new LinkOption[0])) {
                try (InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)tarOutputStream);
                }
            }
            tarOutputStream.closeArchiveEntry();
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Could not add files to TAR Archive: " + e.getMessage());
        }
    }
}

