/*
 * Decompiled with CFR 0.152.
 */
package cech12.unlitcampfire.mixin;

import cech12.unlitcampfire.UnlitCampfireMod;
import cech12.unlitcampfire.config.ServerConfig;
import cech12.unlitcampfire.mixinaccess.ICampfireBlockEntityMixin;
import cech12.unlitcampfire.mixinaccess.ICampfireBlockMixin;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CampfireBlockEntity.class})
public abstract class CampfireBlockEntityMixin
extends BlockEntity
implements ICampfireBlockEntityMixin {
    private Boolean isSoulCampfire;
    private int litTime = 0;
    private int rainTime = 0;

    @Shadow
    protected abstract void m_59069_();

    public CampfireBlockEntityMixin(BlockPos pos, BlockState state) {
        super(BlockEntityType.f_58911_, pos, state);
        UnlitCampfireMod.addCampfire(this);
    }

    @Override
    public boolean isSoulCampfire() {
        if (this.isSoulCampfire == null) {
            if (this.f_58857_ != null) {
                this.isSoulCampfire = this.f_58857_.m_8055_(this.f_58858_).m_60734_() == Blocks.f_50684_;
                return this.isSoulCampfire;
            }
            return false;
        }
        return this.isSoulCampfire;
    }

    private int getMaxLitTime() {
        return ((ICampfireBlockMixin)this.m_58900_().m_60734_()).getMaxLitTime(this.m_58900_());
    }

    private boolean burnsInfinite() {
        return ((ICampfireBlockMixin)this.m_58900_().m_60734_()).burnsInfinite(this.m_58900_());
    }

    private boolean dropsItemsWhenUnlitByTimeOrRain() {
        if (this.isSoulCampfire()) {
            return (Boolean)ServerConfig.SOUL_CAMPFIRE_DROPS_ITEMS_WHEN_UNLIT_BY_TIME_OR_RAIN.get();
        }
        return (Boolean)ServerConfig.CAMPFIRE_DROPS_ITEMS_WHEN_UNLIT_BY_TIME_OR_RAIN.get();
    }

    private boolean breaksWhenUnlitByTime() {
        if (this.isSoulCampfire()) {
            return (Boolean)ServerConfig.SOUL_CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME.get();
        }
        return (Boolean)ServerConfig.CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME.get();
    }

    private int getRainUnlitTime() {
        if (this.isSoulCampfire()) {
            return (Integer)ServerConfig.SOUL_CAMPFIRE_RAIN_UNLIT_TIME.get();
        }
        return (Integer)ServerConfig.CAMPFIRE_RAIN_UNLIT_TIME.get();
    }

    private int getParticleFactorDuringRain() {
        if (this.isSoulCampfire()) {
            return (Integer)ServerConfig.SOUL_CAMPFIRE_RAIN_PARTICLE_FACTOR.get();
        }
        return (Integer)ServerConfig.CAMPFIRE_RAIN_PARTICLE_FACTOR.get();
    }

    private void playUnlitSound() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_5898_(null, 1009, this.m_58899_(), 0);
        }
    }

    private void dropAllContainingItems() {
        if (this.f_58857_ != null) {
            CampfireBlock.m_152749_(null, (LevelAccessor)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
        }
    }

    private void destroyCampfire() {
        if (this.f_58857_ != null) {
            this.playUnlitSound();
            this.dropAllContainingItems();
            this.f_58857_.m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
        }
    }

    private void unlitCampfire() {
        if (this.f_58857_ != null) {
            this.playUnlitSound();
            if (this.dropsItemsWhenUnlitByTimeOrRain()) {
                this.dropAllContainingItems();
            }
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
            this.litTime = 0;
        }
    }

    @Override
    public int getLitTime() {
        return this.litTime;
    }

    @Override
    public boolean addLitTime(int litTimeToAdd) {
        if (this.burnsInfinite()) {
            return false;
        }
        if (litTimeToAdd < 0) {
            return this.removeLitTime(-litTimeToAdd);
        }
        if (this.litTime <= 0 || !((Boolean)this.m_58900_().m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            return false;
        }
        this.litTime -= litTimeToAdd;
        this.m_59069_();
        return true;
    }

    @Override
    public boolean removeLitTime(int litTimeToRemove) {
        if (this.burnsInfinite()) {
            return false;
        }
        if (litTimeToRemove < 0) {
            return this.addLitTime(-litTimeToRemove);
        }
        if (this.litTime >= this.getMaxLitTime() || !((Boolean)this.m_58900_().m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            return false;
        }
        this.litTime += litTimeToRemove;
        this.m_59069_();
        return true;
    }

    @Inject(at={@At(value="RETURN")}, method={"cookTick"})
    private static void cookTickProxy(Level level, BlockPos pos, BlockState state, CampfireBlockEntity blockEntity, CallbackInfo info) {
        CampfireBlockEntityMixin mixinEntity = (CampfireBlockEntityMixin)blockEntity;
        if (level != null) {
            if (((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue() && !mixinEntity.burnsInfinite()) {
                int rainUnlitTime;
                ++mixinEntity.litTime;
                if (mixinEntity.litTime >= mixinEntity.getMaxLitTime()) {
                    if (mixinEntity.breaksWhenUnlitByTime()) {
                        mixinEntity.destroyCampfire();
                    } else {
                        mixinEntity.unlitCampfire();
                    }
                    return;
                }
                if (mixinEntity.litTime % 20 == 1 && (mixinEntity.isSoulCampfire() ? (Boolean)ServerConfig.SOUL_CAMPFIRE_ADDING_BURNABLES.get() : (Boolean)ServerConfig.CAMPFIRE_ADDING_BURNABLES.get()).booleanValue()) {
                    mixinEntity.m_59069_();
                }
                if ((rainUnlitTime = mixinEntity.getRainUnlitTime()) >= 0 && level.m_46758_(pos.m_7494_())) {
                    ++mixinEntity.rainTime;
                    if (mixinEntity.rainTime >= rainUnlitTime) {
                        mixinEntity.rainTime = 0;
                        mixinEntity.unlitCampfire();
                    }
                } else {
                    mixinEntity.rainTime = 0;
                }
            } else {
                mixinEntity.litTime = 0;
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"particleTick"})
    private static void particleTickProxy(Level level, BlockPos pos, BlockState state, CampfireBlockEntity blockEntity, CallbackInfo info) {
        CampfireBlockEntityMixin mixinEntity = (CampfireBlockEntityMixin)blockEntity;
        int particleFactor = mixinEntity.getParticleFactorDuringRain();
        if (level != null && level.f_46443_ && particleFactor > 1 && level.m_46758_(pos.m_7494_())) {
            for (int i = 0; i < particleFactor - 1; ++i) {
                CampfireBlock.m_51251_((Level)level, (BlockPos)pos, (boolean)((Boolean)state.m_61143_((Property)CampfireBlock.f_51228_)), (boolean)false);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"load"})
    protected void loadProxy(CompoundTag nbtIn, CallbackInfo info) {
        if (nbtIn.m_128441_("CampfireLitTime")) {
            this.litTime = nbtIn.m_128451_("CampfireLitTime");
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"saveAdditional"})
    protected void saveAdditionalProxy(CompoundTag compound, CallbackInfo info) {
        if (compound != null) {
            compound.m_128405_("CampfireLitTime", this.litTime);
        }
        UnlitCampfireMod.addCampfire(this);
    }

    @Inject(at={@At(value="RETURN")}, method={"getUpdateTag"})
    protected void getUpdateTagProxy(CallbackInfoReturnable<CompoundTag> info) {
        CompoundTag compound = (CompoundTag)info.getReturnValue();
        if (compound != null) {
            compound.m_128405_("CampfireLitTime", this.litTime);
        }
    }
}

