/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class ColoredParticleData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<ColoredParticleData> DESERIALIZER = new ParticleOptions.Deserializer<ColoredParticleData>(){

        public ColoredParticleData fromCommand(ParticleType<ColoredParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float a = reader.readFloat();
            reader.expect(' ');
            float scale = reader.readFloat();
            return new ColoredParticleData(type, r, g, b, a, scale);
        }

        public ColoredParticleData fromNetwork(ParticleType<ColoredParticleData> type, FriendlyByteBuf buffer) {
            return new ColoredParticleData(type, buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    private final ParticleType<? extends ColoredParticleData> type;
    private final float red;
    private final float green;
    private final float blue;
    private final float alpha;
    private final float scale;

    public static Codec<ColoredParticleData> codec(ParticleType<ColoredParticleData> type) {
        return RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("r").forGetter(ColoredParticleData::getRed), (App)Codec.FLOAT.fieldOf("g").forGetter(ColoredParticleData::getGreen), (App)Codec.FLOAT.fieldOf("b").forGetter(ColoredParticleData::getBlue), (App)Codec.FLOAT.fieldOf("alpha").forGetter(ColoredParticleData::getAlpha), (App)Codec.FLOAT.fieldOf("scale").forGetter(ColoredParticleData::getScale)).apply((Applicative)builder, (r, g, b, a, scale) -> new ColoredParticleData((ParticleType<? extends ColoredParticleData>)type, r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue(), scale.floatValue())));
    }

    public ColoredParticleData(ParticleType<? extends ColoredParticleData> type, float red, float green, float blue, float alpha) {
        this(type, red, green, blue, alpha, 1.0f);
    }

    public ColoredParticleData(ParticleType<? extends ColoredParticleData> type, float red, float green, float blue, float alpha, float scale) {
        this.type = type;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.scale = scale;
    }

    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
        buffer.writeFloat(this.alpha);
        buffer.writeFloat(this.scale);
    }

    public String m_5942_() {
        return PlatformUtils.INSTANCE.particles().getIDFrom(this.m_6012_()).toString();
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getScale() {
        return this.scale;
    }
}

