/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.entity;

public class AnimatedAction {
    public static final AnimatedAction vanillaAttack = new AnimatedAction(20, 1, "vanilla");
    public static final AnimatedAction[] vanillaAttackOnly = new AnimatedAction[]{vanillaAttack};
    private final int length;
    private final int attackTime;
    private final boolean shouldRunOut;
    private final String id;
    private final String animationClient;
    private float ticker;
    private float speed = 1.0f;

    public AnimatedAction(int length, String id) {
        this(length, 1, id, id);
    }

    public AnimatedAction(int length, int attackTime, String id) {
        this(length, attackTime, id, id);
    }

    public AnimatedAction(int length, int attackTime, String id, String animationClient) {
        this(length, attackTime, id, animationClient, 1.0f, true);
    }

    public AnimatedAction(int length, int attackTime, String id, String animationClient, float speedMod, boolean shouldRunOut) {
        this.speed = speedMod;
        this.length = length;
        this.attackTime = Math.max(1, attackTime);
        this.id = id;
        this.animationClient = animationClient;
        this.shouldRunOut = shouldRunOut;
    }

    public static AnimatedAction copyOf(AnimatedAction animatedAction, String id) {
        return new AnimatedAction(animatedAction.length, animatedAction.attackTime, id, animatedAction.animationClient, animatedAction.speed, animatedAction.shouldRunOut);
    }

    public AnimatedAction create() {
        return new AnimatedAction(this.length, this.attackTime, this.id, this.animationClient, this.speed, this.shouldRunOut);
    }

    public boolean tick() {
        return this.tick(1);
    }

    public boolean tick(int offSet) {
        float f;
        this.ticker += 1.0f * this.speed;
        return f >= (float)(this.length + offSet) && this.shouldRunOut;
    }

    public boolean canAttack() {
        return this.ticker == (float)this.attackTime;
    }

    public int getTick() {
        return (int)this.ticker;
    }

    public int getLength() {
        return this.length;
    }

    public int getAttackTime() {
        return this.attackTime;
    }

    public void reset() {
        this.ticker = 0.0f;
    }

    public String getID() {
        return this.id;
    }

    public boolean checkID(AnimatedAction other) {
        return other != null && this.id.equals(other.id);
    }

    public String getAnimationClient() {
        return this.animationClient;
    }

    public boolean shouldRunOut() {
        return this.shouldRunOut;
    }

    public String toString() {
        return "ID: " + this.id + "; length: " + this.length + "; attackTime: " + this.attackTime + "; speed: " + this.speed;
    }

    public boolean equals(Object o) {
        if (o instanceof AnimatedAction) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

