/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.util;

import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.util.TTCRenderTypes;
import andrews.table_top_craft.util.obj.models.ChessObjModel;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;

public class DrawScreenHelper {
    public static final VertexFormat chessVertexFormat = TTCRenderTypes.getChessPieceSolid(new ResourceLocation("table_top_craft", "textures/tile/chess/pieces.png")).m_110508_();
    public static final ChessObjModel CHESS_PIECE_MODEL = new ChessObjModel();
    public static final HashMap<Pair<BasePiece.PieceType, BasePiece.PieceModelSet>, VertexBuffer> BUFFERS = new HashMap();

    public static void setup() {
        BufferBuilder chessBuilder = new BufferBuilder(256);
        for (BasePiece.PieceType type : BasePiece.PieceType.values()) {
            for (BasePiece.PieceModelSet set : BasePiece.PieceModelSet.values()) {
                BUFFERS.put((Pair<BasePiece.PieceType, BasePiece.PieceModelSet>)Pair.of((Object)((Object)type), (Object)((Object)set)), DrawScreenHelper.generate(chessBuilder, chessVertexFormat, type, set));
            }
        }
    }

    private static VertexBuffer generate(BufferBuilder builder, VertexFormat format, BasePiece.PieceType type, BasePiece.PieceModelSet set) {
        builder.m_166779_(VertexFormat.Mode.TRIANGLES, format);
        CHESS_PIECE_MODEL.render(new PoseStack(), (VertexConsumer)builder, type, set);
        VertexBuffer buffer = BUFFERS.getOrDefault(Pair.of((Object)((Object)type), (Object)((Object)set)), null);
        if (buffer == null) {
            buffer = new VertexBuffer();
        }
        DrawScreenHelper.upload(buffer, builder);
        return buffer;
    }

    private static void upload(VertexBuffer buffer, BufferBuilder builder) {
        buffer.m_85921_();
        buffer.m_231221_(builder.m_231175_());
        VertexBuffer.m_85931_();
        builder.m_85729_();
    }

    public static VertexBuffer getBuffer(BasePiece.PieceModelSet set, BasePiece.PieceType piece) {
        return BUFFERS.get(Pair.of((Object)((Object)piece), (Object)((Object)set)));
    }
}

