/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.util;

import java.util.Objects;

public class Color {
    private final int value;

    public Color(int rgb) {
        this.value = 0xFF000000 | rgb;
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, int a) {
        this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public Color(float v, float v1, float v2, boolean RGB) {
        this(v, v1, v2, 255, RGB);
    }

    public Color(float v, float v1, float v2, int alpha, boolean RGB) {
        if (RGB) {
            int r = (int)(v * 255.0f);
            int g = (int)(v1 * 255.0f);
            int b = (int)(v2 * 255.0f);
            this.value = (alpha & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        } else {
            Color c = this.fromHSV(v, v1, v2);
            Color c1 = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
            this.value = c1.value;
        }
    }

    public static float[] toHSV(Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float colorMax = Math.max(r, Math.max(b, g));
        float colorMin = Math.min(r, Math.min(b, g));
        float delta = colorMax - colorMin;
        float hue = 0.0f;
        if (delta != 0.0f) {
            if (colorMax == r) {
                hue = 60.0f * ((g - b) / delta % 6.0f);
            } else if (colorMax == g) {
                hue = 60.0f * (b - r + 2.0f);
            } else if (colorMax == b) {
                hue = 60.0f * (r - g + 4.0f);
            }
        }
        float saturation = 0.0f;
        if (colorMax != 0.0f) {
            saturation = delta / colorMax;
        }
        if (hue < 0.0f) {
            hue = 360.0f + hue;
        }
        return new float[]{hue, saturation, colorMax};
    }

    public float getHue() {
        return Color.toHSV(this)[0];
    }

    public float getSaturation() {
        return Color.toHSV(this)[1];
    }

    public float getValue() {
        return Color.toHSV(this)[2];
    }

    public Color darker(float amt, float hueShiftScale) {
        Color darker = new Color(Math.max((int)((float)this.getRed() * amt), 0), Math.max((int)((float)this.getGreen() * amt), 0), Math.max((int)((float)this.getBlue() * amt), 0), this.getAlpha());
        if (hueShiftScale == 0.0f) {
            return darker;
        }
        return new Color(darker.getHue() - hueShiftScale * amt, darker.getSaturation(), darker.getValue(), false);
    }

    public Color brighter(float amt, float hueShiftScale) {
        int r = this.getRed();
        int g = this.getGreen();
        int b = this.getBlue();
        int alpha = this.getAlpha();
        Color brighter = null;
        int i = (int)(1.0 / (1.0 - (double)amt));
        if (r == 0 && g == 0 && b == 0) {
            brighter = new Color(i, i, i, alpha);
        }
        if (brighter == null) {
            if (r > 0 && r < i) {
                r = i;
            }
            if (g > 0 && g < i) {
                g = i;
            }
            if (b > 0 && b < i) {
                b = i;
            }
            brighter = new Color(Math.min((int)((float)r / amt), 255), Math.min((int)((float)g / amt), 255), Math.min((int)((float)b / amt), 255), alpha);
        }
        if (hueShiftScale == 0.0f) {
            return brighter;
        }
        return new Color(brighter.getHue() + hueShiftScale * amt, brighter.getSaturation(), brighter.getValue(), false);
    }

    public Color hueshift(float amt) {
        return new Color(this.getHue() + amt, this.getSaturation(), this.getValue(), false);
    }

    public Color fromHSV(float hue, float saturation, float value) {
        if ((hue %= 360.0f) < 0.0f) {
            hue += 360.0f;
        }
        float c = value * saturation;
        float x = c * (1.0f - Math.abs(hue / 60.0f % 2.0f - 1.0f));
        float m = value - c;
        float rPrime = 0.0f;
        float gPrime = 0.0f;
        float bPrime = 0.0f;
        float num = hue / 60.0f;
        if (0.0f <= num && num < 2.0f) {
            rPrime = num < 1.0f ? c : x;
            gPrime = num < 1.0f ? x : c;
        } else if (2.0f <= num && num < 4.0f) {
            gPrime = num < 3.0f ? c : x;
            bPrime = num < 3.0f ? x : c;
        } else if (4.0f <= num && num < 6.0f) {
            rPrime = num < 5.0f ? x : c;
            bPrime = num < 5.0f ? c : x;
        }
        float r = (rPrime + m) * 255.0f;
        float g = (gPrime + m) * 255.0f;
        float b = (bPrime + m) * 255.0f;
        return new Color((int)r, (int)g, (int)b);
    }

    public String toString() {
        return "Color{r:" + this.getRed() + ",g:" + this.getGreen() + ",b:" + this.getBlue() + ",a:" + this.getAlpha() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return this.value == color.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

