/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.tile_entities.render;

import andrews.table_top_craft.objects.blocks.ConnectFourBlock;
import andrews.table_top_craft.tile_entities.ConnectFourBlockEntity;
import andrews.table_top_craft.tile_entities.model.connect_four.ConnectFourFallingPieceModel;
import andrews.table_top_craft.tile_entities.model.connect_four.ConnectFourMeshModel;
import andrews.table_top_craft.tile_entities.model.connect_four.ConnectFourPieceModel;
import andrews.table_top_craft.util.Color;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class ConnectFourBlockEntityRenderer
implements BlockEntityRenderer<ConnectFourBlockEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("table_top_craft", "textures/tile/connect_four/connect_four.png");
    private final ConnectFourMeshModel meshModel;
    private final ConnectFourPieceModel pieceModel;
    private final ConnectFourFallingPieceModel fallingPieceModel;
    private final float PIXEL_SIZE = 0.0625f;

    public ConnectFourBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.meshModel = new ConnectFourMeshModel(context.m_173582_(ConnectFourMeshModel.LAYER));
        this.pieceModel = new ConnectFourPieceModel(context.m_173582_(ConnectFourPieceModel.LAYER));
        this.fallingPieceModel = new ConnectFourFallingPieceModel(context.m_173582_(ConnectFourFallingPieceModel.LAYER));
    }

    public void render(ConnectFourBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.fallingPieceModel.updateAnimations(blockEntity, partialTick);
        Direction facing = Direction.NORTH;
        if (blockEntity.m_58900_().m_61138_((Property)ConnectFourBlock.FACING)) {
            facing = (Direction)blockEntity.m_58900_().m_61143_((Property)ConnectFourBlock.FACING);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        poseStack.m_85837_(0.0, -0.125, 0.0);
        switch (facing) {
            default: {
                break;
            }
            case WEST: 
            case EAST: {
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(270.0f));
            }
        }
        this.meshModel.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE)), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
        poseStack.m_85837_(-0.375, 0.0, 0.0);
        String[] columns = blockEntity.getColumns();
        List<Integer> winIdxList = blockEntity.getFourInRow();
        Color colorIron = new Color(blockEntity.ironColor);
        float brightnessIron = 0.2126f * (float)colorIron.getRed() + 0.7152f * (float)colorIron.getGreen() + 0.0722f * (float)colorIron.getBlue();
        Color colorGold = new Color(blockEntity.goldColor);
        float brightnessGold = 0.2126f * (float)colorGold.getRed() + 0.7152f * (float)colorGold.getGreen() + 0.0722f * (float)colorGold.getBlue();
        Color altColorIron = brightnessIron > 128.0f ? colorIron.darker(0.75f, 0.0f) : colorIron.brighter(0.75f, 0.0f);
        Color altColorGold = brightnessGold > 128.0f ? colorGold.darker(0.75f, 0.0f) : colorGold.brighter(0.75f, 0.0f);
        byte idx = -1;
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 6; ++y) {
                ++idx;
                poseStack.m_85836_();
                poseStack.m_85837_((double)(0.125f * (float)x), -0.125 * (double)y, 0.0);
                if (columns[x].charAt(y) == 'i' || columns[x].charAt(y) == 'g') {
                    float blue;
                    boolean isWhite = columns[x].charAt(y) == 'i';
                    float red = isWhite ? (float)colorIron.getRed() : (float)colorGold.getRed();
                    float green = isWhite ? (float)colorIron.getGreen() : (float)colorGold.getGreen();
                    float f = blue = isWhite ? (float)colorIron.getBlue() : (float)colorGold.getBlue();
                    if (!winIdxList.isEmpty() && winIdxList.contains(idx)) {
                        int tickSwapSpeed = 10;
                        float deltaTime = blockEntity.getTicksExisted() / tickSwapSpeed % 2 == 0 ? ((float)(blockEntity.getTicksExisted() % tickSwapSpeed) + partialTick) / (float)tickSwapSpeed : 1.0f - ((float)(blockEntity.getTicksExisted() % tickSwapSpeed) + partialTick) / (float)tickSwapSpeed;
                        red = isWhite ? Mth.m_14179_((float)deltaTime, (float)altColorIron.getRed(), (float)colorIron.getRed()) : Mth.m_14179_((float)deltaTime, (float)altColorGold.getRed(), (float)colorGold.getRed());
                        green = isWhite ? Mth.m_14179_((float)deltaTime, (float)altColorIron.getGreen(), (float)colorIron.getGreen()) : Mth.m_14179_((float)deltaTime, (float)altColorGold.getGreen(), (float)colorGold.getGreen());
                        float f2 = blue = isWhite ? Mth.m_14179_((float)deltaTime, (float)altColorIron.getBlue(), (float)colorIron.getBlue()) : Mth.m_14179_((float)deltaTime, (float)altColorGold.getBlue(), (float)colorGold.getBlue());
                    }
                    if (blockEntity.movingPiece == idx) {
                        poseStack.m_85836_();
                        poseStack.m_85841_(1.0f, 1.0f, 0.95f);
                        this.fallingPieceModel.m_7695_(poseStack, consumer, packedLight, packedOverlay, red / 255.0f, green / 255.0f, blue / 255.0f, 1.0f);
                        poseStack.m_85849_();
                    } else {
                        this.pieceModel.m_7695_(poseStack, consumer, packedLight, packedOverlay, red / 255.0f, green / 255.0f, blue / 255.0f, 1.0f);
                    }
                }
                poseStack.m_85849_();
            }
        }
        poseStack.m_85849_();
    }
}

