/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.tile_entities;

import andrews.table_top_craft.animation.system.base.AnimatedBlockEntity;
import andrews.table_top_craft.animation.system.core.AdvancedAnimationState;
import andrews.table_top_craft.registry.TTCBlockEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ConnectFourBlockEntity
extends AnimatedBlockEntity {
    private String game = "------/------/------/------/------/------/------";
    public AdvancedAnimationState moveState;
    public byte movingPiece = (byte)-1;
    public int ironColor = 0xF9FFFE;
    public int goldColor = 16701501;

    public ConnectFourBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TTCBlockEntities.CONNECT_FOUR.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        AABB aabb = super.getRenderBoundingBox();
        return aabb.m_82363_(0.0, 0.125, 0.0);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        this.saveToNBT(compound);
        return compound;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveToNBT(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadFromNBT(compound);
    }

    private void saveToNBT(CompoundTag compound) {
        CompoundTag connectFourTag = new CompoundTag();
        connectFourTag.m_128359_("Game", this.game);
        connectFourTag.m_128405_("IronColor", this.ironColor);
        connectFourTag.m_128405_("GoldColor", this.goldColor);
        compound.m_128365_("ConnectFourValues", (Tag)connectFourTag);
    }

    private void loadFromNBT(CompoundTag compound) {
        CompoundTag connectFourTag = compound.m_128469_("ConnectFourValues");
        this.game = this.isValidGame(connectFourTag.m_128461_("Game")) ? connectFourTag.m_128461_("Game") : "------/------/------/------/------/------/------";
        this.ironColor = connectFourTag.m_128451_("IronColor");
        this.goldColor = connectFourTag.m_128451_("GoldColor");
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ConnectFourBlockEntity blockEntity) {
        blockEntity.incTicksExisted();
        if (level.m_5776_() && blockEntity.moveState != null && blockEntity.moveState.isFinished()) {
            blockEntity.movingPiece = (byte)-1;
            blockEntity.moveState = null;
        }
    }

    private boolean isValidGame(String game) {
        String[] columns = game.split("/");
        if (columns.length != 7) {
            return false;
        }
        for (String column : columns) {
            if (column.length() == 6) continue;
            return false;
        }
        return true;
    }

    public String[] getColumns() {
        return this.game.split("/");
    }

    public void addPieceToColumn(byte column) {
        if (this.isValidGame(this.game)) {
            String[] columns = this.getColumns();
            for (int i = 0; i < 6; ++i) {
                char columnElement = columns[column].charAt(i);
                if (columnElement == 'g' || columnElement == 'i') continue;
                StringBuilder builder = new StringBuilder();
                builder.append(this.game);
                builder.setCharAt(column * 7 + i, this.getTotalPieces() % 2 == 0 ? (char)'g' : 'i');
                this.game = builder.toString();
                return;
            }
        }
    }

    public int getTotalPieces() {
        int count = 0;
        for (int i = 0; i < this.game.length(); ++i) {
            if (this.game.charAt(i) != 'i' && this.game.charAt(i) != 'g') continue;
            ++count;
        }
        return count;
    }

    public int getTopPieceInColumn(byte column) {
        if (this.isValidGame(this.game)) {
            String[] columns = this.getColumns();
            for (int i = 5; i > 0; --i) {
                char columnElement = columns[column].charAt(i);
                if (columnElement != 'g' && columnElement != 'i') continue;
                return i;
            }
        }
        return 0;
    }

    public void reset() {
        this.game = "------/------/------/------/------/------/------";
    }

    public List<Integer> getFourInRow() {
        int row;
        int col;
        if (!this.isValidGame(this.game)) {
            return new ArrayList<Integer>();
        }
        char[][] board = new char[7][6];
        String[] columns = this.game.split("/");
        for (int i = 0; i < 7; ++i) {
            board[i] = columns[i].toCharArray();
        }
        for (col = 0; col < 7; ++col) {
            for (row = 0; row < 3; ++row) {
                if (board[col][row] == '-' || board[col][row] != board[col][row + 1] || board[col][row] != board[col][row + 2] || board[col][row] != board[col][row + 3]) continue;
                return Arrays.asList(col * 6 + row, col * 6 + row + 1, col * 6 + row + 2, col * 6 + row + 3);
            }
        }
        for (col = 0; col < 4; ++col) {
            for (row = 0; row < 6; ++row) {
                if (board[col][row] == '-' || board[col][row] != board[col + 1][row] || board[col][row] != board[col + 2][row] || board[col][row] != board[col + 3][row]) continue;
                return Arrays.asList(col * 6 + row, (col + 1) * 6 + row, (col + 2) * 6 + row, (col + 3) * 6 + row);
            }
        }
        for (col = 0; col < 4; ++col) {
            for (row = 0; row < 3; ++row) {
                if (board[col][row] == '-' || board[col][row] != board[col + 1][row + 1] || board[col][row] != board[col + 2][row + 2] || board[col][row] != board[col + 3][row + 3]) continue;
                return Arrays.asList(col * 6 + row, (col + 1) * 6 + row + 1, (col + 2) * 6 + row + 2, (col + 3) * 6 + row + 3);
            }
        }
        for (col = 6; col >= 3; --col) {
            for (row = 0; row < 3; ++row) {
                if (board[col][row] == '-' || board[col][row] != board[col - 1][row + 1] || board[col][row] != board[col - 2][row + 2] || board[col][row] != board[col - 3][row + 3]) continue;
                return Arrays.asList(col * 6 + row, (col - 1) * 6 + row + 1, (col - 2) * 6 + row + 2, (col - 3) * 6 + row + 3);
            }
        }
        return new ArrayList<Integer>();
    }

    public boolean hasFourInARow() {
        return !this.getFourInRow().isEmpty();
    }
}

