/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.tile_entities;

import andrews.table_top_craft.objects.blocks.ChessTimerBlock;
import andrews.table_top_craft.registry.TTCBlockEntities;
import andrews.table_top_craft.util.NetworkUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ChessTimerBlockEntity
extends BlockEntity {
    private long leftTimer = 1800000L;
    private long rightTimer = 1800000L;
    public long leftTimerCache;
    public long rightTimerCache;
    public long lastSwitchTime;

    public ChessTimerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TTCBlockEntities.CHESS_TIMER.get(), pos, state);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        this.saveToNBT(compound);
        return compound;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveToNBT(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadFromNBT(compound);
    }

    private void saveToNBT(CompoundTag compound) {
        CompoundTag chessTimerTag = new CompoundTag();
        chessTimerTag.m_128356_("LeftTimer", this.leftTimer);
        chessTimerTag.m_128356_("RightTimer", this.rightTimer);
        compound.m_128365_("ChessTimerValues", (Tag)chessTimerTag);
        if (this.m_58904_() != null && !this.m_58904_().m_5776_() && this.rightTimerCache == 0L) {
            this.leftTimerCache = System.currentTimeMillis();
            this.rightTimerCache = System.currentTimeMillis();
        }
    }

    private void loadFromNBT(CompoundTag compound) {
        CompoundTag chessTimerTag = compound.m_128469_("ChessTimerValues");
        this.leftTimer = chessTimerTag.m_128454_("LeftTimer");
        this.rightTimer = chessTimerTag.m_128454_("RightTimer");
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ChessTimerBlockEntity blockEntity) {
        if (!level.m_5776_()) {
            if (((ChessTimerBlock.PressedButton)((Object)state.m_61143_(ChessTimerBlock.PRESSED_BUTTON))).equals((Object)ChessTimerBlock.PressedButton.LEFT)) {
                if (System.currentTimeMillis() >= blockEntity.rightTimerCache) {
                    boolean updateNeighbors = false;
                    blockEntity.rightTimerCache = System.currentTimeMillis() + 1000L;
                    if (blockEntity.getRightTimer() == 1000L) {
                        updateNeighbors = true;
                    }
                    blockEntity.modifyRightTimer(-1000L);
                    level.m_7260_(pos, state, state, 2);
                    if (updateNeighbors) {
                        level.m_46672_(pos, state.m_60734_());
                        level.m_46597_(pos, (BlockState)state.m_61124_(ChessTimerBlock.PRESSED_BUTTON, (Comparable)((Object)ChessTimerBlock.PressedButton.NONE)));
                        NetworkUtil.playChesTimerSoundFromServer(level, pos, (byte)1);
                    }
                    blockEntity.m_6596_();
                }
            } else if (((ChessTimerBlock.PressedButton)((Object)state.m_61143_(ChessTimerBlock.PRESSED_BUTTON))).equals((Object)ChessTimerBlock.PressedButton.RIGHT) && System.currentTimeMillis() >= blockEntity.leftTimerCache) {
                boolean updateNeighbors = false;
                blockEntity.leftTimerCache = System.currentTimeMillis() + 1000L;
                if (blockEntity.getLeftTimer() == 1000L) {
                    updateNeighbors = true;
                }
                blockEntity.modifyLeftTimer(-1000L);
                level.m_7260_(pos, state, state, 2);
                if (updateNeighbors) {
                    level.m_46672_(pos, state.m_60734_());
                    level.m_46597_(pos, (BlockState)state.m_61124_(ChessTimerBlock.PRESSED_BUTTON, (Comparable)((Object)ChessTimerBlock.PressedButton.NONE)));
                    NetworkUtil.playChesTimerSoundFromServer(level, pos, (byte)1);
                }
                blockEntity.m_6596_();
            }
        }
    }

    public long getLeftTimer() {
        return this.leftTimer;
    }

    public long getRightTimer() {
        return this.rightTimer;
    }

    public void modifyLeftTimer(long amount) {
        this.leftTimer = Mth.m_14053_((long)(this.leftTimer + amount), (long)0L, (long)359999000L);
    }

    public void modifyRightTimer(long amount) {
        this.rightTimer = Mth.m_14053_((long)(this.rightTimer + amount), (long)0L, (long)359999000L);
    }

    public void resetTimers() {
        this.leftTimer = 1800000L;
        this.rightTimer = 1800000L;
    }
}

