/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.menus.color_selection;

import andrews.table_top_craft.screens.chess.buttons.ChessCancelButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessConfirmColorButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessRandomColorButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessResetColorButton;
import andrews.table_top_craft.screens.chess.sliders.ChessAlphaColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessBlueColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessGreenColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessRedColorSlider;
import andrews.table_top_craft.screens.piece_figure.util.ColorPickerToggleButton;
import andrews.table_top_craft.screens.piece_figure.util.IColorPicker;
import andrews.table_top_craft.screens.piece_figure.util.SaturationSlider;
import andrews.table_top_craft.screens.piece_figure.util.TTCColorPicker;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.NBTColorSaving;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class ChessBoardLegalMoveColorScreen
extends Screen
implements IColorPicker {
    private static final ResourceLocation MENU_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/medium_chess_menu.png");
    private static final ResourceLocation PREVIEW_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/preview_color.png");
    private static final ResourceLocation COLOR_PICKER_FRAME_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/color_picker/color_picker_frame.png");
    private final String colorSelectionText = Component.m_237115_((String)"gui.table_top_craft.chess.color.legal_move").getString();
    private final String previewColorText = Component.m_237115_((String)"gui.table_top_craft.chess.color.color_preview").getString();
    private final ChessTileEntity chessTileEntity;
    private final int xSize = 177;
    private final int ySize = 131;
    private ChessAlphaColorSlider alphaColorSlider;
    private ChessRedColorSlider redColorSlider;
    private ChessGreenColorSlider greenColorSlider;
    private ChessBlueColorSlider blueColorSlider;
    private TTCColorPicker colorPicker;
    private SaturationSlider saturationSlider;
    private final boolean isColorPickerActive;

    public ChessBoardLegalMoveColorScreen(ChessTileEntity chessTileEntity, boolean isColorPickerActive) {
        super((Component)Component.m_237113_((String)""));
        this.chessTileEntity = chessTileEntity;
        this.isColorPickerActive = isColorPickerActive;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - (this.xSize - (this.isColorPickerActive ? 136 : 0))) / 2;
        int y = (this.f_96544_ - this.ySize) / 2;
        this.m_142416_((GuiEventListener)new ColorPickerToggleButton(this.chessTileEntity, this, false, x + 48, y + 47));
        this.redColorSlider = new ChessRedColorSlider(x + 5, y + 61, 167, 12, NBTColorSaving.getRed(this.chessTileEntity.getLegalMoveColor()), this);
        this.m_142416_((GuiEventListener)this.redColorSlider);
        this.greenColorSlider = new ChessGreenColorSlider(x + 5, y + 74, 167, 12, NBTColorSaving.getGreen(this.chessTileEntity.getLegalMoveColor()), this);
        this.m_142416_((GuiEventListener)this.greenColorSlider);
        this.blueColorSlider = new ChessBlueColorSlider(x + 5, y + 87, 167, 12, NBTColorSaving.getBlue(this.chessTileEntity.getLegalMoveColor()), this);
        this.m_142416_((GuiEventListener)this.blueColorSlider);
        this.alphaColorSlider = new ChessAlphaColorSlider(x + 5, y + 100, 167, 12, NBTColorSaving.getAlpha(this.chessTileEntity.getLegalMoveColor()));
        this.m_142416_((GuiEventListener)this.alphaColorSlider);
        this.m_142416_((GuiEventListener)new ChessRandomColorButton(this, x + 69, y + 33));
        this.m_142416_((GuiEventListener)new ChessResetColorButton(ChessResetColorButton.DefaultColorType.LEGAL_MOVE, this, x + 69, y + 47));
        this.m_142416_((GuiEventListener)new ChessCancelButton(this.chessTileEntity, ChessCancelButton.ChessCancelMenuTarget.CHESS_BOARD_COLORS, ChessCancelButton.ChessCancelButtonText.CANCEL, x + 5, y + 113));
        this.m_142416_((GuiEventListener)new ChessConfirmColorButton(ChessConfirmColorButton.ColorMenuType.LEGAL_MOVE, this.chessTileEntity, this.redColorSlider, this.greenColorSlider, this.blueColorSlider, this.alphaColorSlider, x + 90, y + 113));
        if (this.isColorPickerActive) {
            Color color = new Color(this.redColorSlider.getValueInt(), this.greenColorSlider.getValueInt(), this.blueColorSlider.getValueInt());
            this.colorPicker = new TTCColorPicker(x - 131, y - 5, this, color.getHue() / 360.0f, 1.0f - color.getValue());
            this.m_142416_((GuiEventListener)this.colorPicker);
            float saturation = color.getSaturation() * 100.0f;
            this.saturationSlider = new SaturationSlider(x - 132, y + 125, 130, 12, Math.round(saturation), this);
            this.m_142416_((GuiEventListener)this.saturationSlider);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int x = (this.f_96543_ - (this.xSize - (this.isColorPickerActive ? 136 : 0))) / 2;
        int y = (this.f_96544_ - this.ySize) / 2;
        if (this.isColorPickerActive) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)COLOR_PICKER_FRAME_TEXTURE);
            this.m_93228_(poseStack, x - 136, y - 10, 0, 0, 139, 151);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MENU_TEXTURE);
        this.m_93228_(poseStack, x, y, 0, 0, this.xSize, this.ySize);
        this.m_93228_(poseStack, x + 5, y + 18, 0, 131, 42, 42);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PREVIEW_TEXTURE);
        poseStack.m_85836_();
        RenderSystem.m_157429_((float)(0.003921569f * (float)this.redColorSlider.getValueInt()), (float)(0.003921569f * (float)this.greenColorSlider.getValueInt()), (float)(0.003921569f * (float)this.blueColorSlider.getValueInt()), (float)(0.003921569f * (float)this.alphaColorSlider.getValueInt()));
        poseStack.m_85837_((double)(x + 6), (double)(y + 19), 0.0);
        poseStack.m_85841_(2.5f, 2.5f, 2.5f);
        this.m_93228_(poseStack, 0, 0, 0, 0, 16, 16);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
        this.f_96547_.m_92883_(poseStack, this.colorSelectionText, (float)(this.f_96543_ / 2 - this.f_96547_.m_92895_(this.colorSelectionText) / 2 + (this.isColorPickerActive ? 68 : 0)), (float)(y + 6), 0x404040);
        this.f_96547_.m_92883_(poseStack, this.previewColorText, (float)(x + 49), (float)(y + 18), 0);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
        }
        return true;
    }

    @Override
    public TTCColorPicker getColorPicker() {
        return this.colorPicker;
    }

    @Override
    public ForgeSlider getRedSlider() {
        return this.redColorSlider;
    }

    @Override
    public ForgeSlider getGreenSlider() {
        return this.greenColorSlider;
    }

    @Override
    public ForgeSlider getBlueSlider() {
        return this.blueColorSlider;
    }

    @Override
    public ForgeSlider getSaturationSlider() {
        return this.saturationSlider;
    }

    @Override
    public boolean isColorPickerActive() {
        return this.isColorPickerActive;
    }
}

