/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.menus;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessBoardColorSettingsButton;
import andrews.table_top_craft.screens.chess.buttons.pieces.ChessBoardPieceSettingsButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessBoardSettingsButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessCopyFENButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessEvaluateBoardButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessLoadFENButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessMoveLogDownButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessMoveLogUpButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessNewGameButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessShowAvailableMovesButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessShowPreviousMoveButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessShowTileInfoButton;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ChessBoardSettingsScreen
extends Screen {
    private static final ResourceLocation MENU_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/chess_menu.png");
    private static final ResourceLocation MOVE_LOG_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/move_log.png");
    private final String chessBoardSettingsText = Component.m_237115_((String)"gui.table_top_craft.chess.board_settings").getString();
    private final String moveLogText = Component.m_237115_((String)"gui.table_top_craft.chess.move_log").getString();
    private final String moveLogWhiteText = Component.m_237115_((String)"gui.table_top_craft.chess.move_log.white").getString();
    private final String moveLogBlackText = Component.m_237115_((String)"gui.table_top_craft.chess.move_log.black").getString();
    private final String showTileInfoText = Component.m_237115_((String)"gui.table_top_craft.chess.show_tile_info").getString();
    private final String showAvailableMovesText = Component.m_237115_((String)"gui.table_top_craft.chess.show_available_moves").getString();
    private final String showPreviousMoveText = Component.m_237115_((String)"gui.table_top_craft.chess.show_previous_move").getString();
    private final ChessTileEntity chessTileEntity;
    private final int xSize = 177;
    private final int ySize = 198;
    private int moveLogOffset;

    public ChessBoardSettingsScreen(ChessTileEntity chessTileEntity) {
        super((Component)Component.m_237113_((String)""));
        this.chessTileEntity = chessTileEntity;
        this.moveLogOffset = 0;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.xSize) / 2;
        int y = (this.f_96544_ - this.ySize) / 2;
        this.m_142416_((GuiEventListener)new ChessBoardSettingsButton(this.chessTileEntity, x - 24, y + 16));
        this.m_142416_((GuiEventListener)new ChessBoardColorSettingsButton(this.chessTileEntity, x - 24, y + 42));
        this.m_142416_((GuiEventListener)new ChessBoardPieceSettingsButton(this.chessTileEntity, x - 24, y + 68));
        this.m_142416_((GuiEventListener)new ChessNewGameButton(this.chessTileEntity.m_58899_(), x + 5, y + 16));
        this.m_142416_((GuiEventListener)new ChessEvaluateBoardButton(this.chessTileEntity, x + 90, y + 16));
        this.m_142416_((GuiEventListener)new ChessCopyFENButton(this.chessTileEntity, x + 5, y + 31));
        this.m_142416_((GuiEventListener)new ChessLoadFENButton(this.chessTileEntity, x + 90, y + 31));
        this.m_142416_((GuiEventListener)new ChessShowTileInfoButton(this.chessTileEntity, x + 5, y + 46));
        this.m_142416_((GuiEventListener)new ChessShowAvailableMovesButton(this.chessTileEntity, x + 5, y + 60));
        this.m_142416_((GuiEventListener)new ChessShowPreviousMoveButton(this.chessTileEntity, x + 5, y + 74));
        this.m_142416_((GuiEventListener)new ChessMoveLogDownButton(x + 161, y + 112, this));
        this.m_142416_((GuiEventListener)new ChessMoveLogUpButton(x + 161, y + 167, this, this.chessTileEntity));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int x = (this.f_96543_ - this.xSize) / 2;
        int y = (this.f_96544_ - this.ySize) / 2;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MENU_TEXTURE);
        this.m_93228_(poseStack, x, y, 0, 0, this.xSize, this.ySize);
        this.m_93228_(poseStack, x, y + 15, 0, 198, 3, 26);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MOVE_LOG_TEXTURE);
        this.m_93228_(poseStack, x + 5, y + 101, 0, 0, 155, 89);
        for (int i = 0; i < (this.moveLogOffset % 2 != 0 ? 3 : 4); ++i) {
            this.m_93228_(poseStack, x + 6, y + 124 + i * 22 - (this.moveLogOffset % 2 != 0 ? 0 : 11), 0, 89, 153, 10);
        }
        this.f_96547_.m_92883_(poseStack, this.chessBoardSettingsText, (float)(this.f_96543_ / 2 - this.f_96547_.m_92895_(this.chessBoardSettingsText) / 2), (float)(y + 6), 0x404040);
        this.f_96547_.m_92883_(poseStack, this.moveLogText, (float)(this.f_96543_ / 2 - this.f_96547_.m_92895_(this.moveLogText) / 2), (float)(y + 90), 0x404040);
        this.f_96547_.m_92883_(poseStack, this.showTileInfoText, (float)(x + 20), (float)(y + 49), 0);
        this.f_96547_.m_92883_(poseStack, this.showAvailableMovesText, (float)(x + 20), (float)(y + 63), 0);
        this.f_96547_.m_92883_(poseStack, this.showPreviousMoveText, (float)(x + 20), (float)(y + 77), 0);
        this.f_96547_.m_92883_(poseStack, this.moveLogWhiteText, (float)(x + 54 - this.f_96547_.m_92895_(this.moveLogWhiteText) / 2), (float)(y + 103), 0);
        this.f_96547_.m_92883_(poseStack, this.moveLogBlackText, (float)(x + 124 - this.f_96547_.m_92895_(this.moveLogBlackText) / 2), (float)(y + 103), 0);
        int offset = 0;
        int currentMoveId = 1;
        if (this.chessTileEntity.getMoveLog() != null) {
            offset -= this.moveLogOffset * 11;
            for (int i = 0; i < this.chessTileEntity.getMoveLog().getMoves().size(); ++i) {
                PieceColor pieceColor = this.chessTileEntity.getMoveLog().getMoves().get(i).getMovedPiece().getPieceColor();
                String moveName = this.chessTileEntity.getMoveLog().getMoves().get(i).toString();
                if (this.moveLogOffset * 2 <= i && this.moveLogOffset * 2 + 14 > i) {
                    this.f_96547_.m_92883_(poseStack, moveName, (float)(x - moveName.length() * 6 / 2 + 54 + (pieceColor == PieceColor.WHITE ? 0 : 70)), (float)(y + 114 + offset), 0);
                    if (i % 2 == 0) {
                        this.f_96547_.m_92883_(poseStack, String.valueOf(currentMoveId + this.moveLogOffset), (float)(x + 7 + (currentMoveId + this.moveLogOffset > 9 ? 0 : 3)), (float)(y + 114 + offset), 0);
                        ++currentMoveId;
                    }
                }
                if (i % 2 == 0) continue;
                offset += 11;
            }
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
        }
        return true;
    }

    public int getMoveLogOffset() {
        return this.moveLogOffset;
    }

    public void decreaseMoveLogOffset() {
        if (this.moveLogOffset > 0) {
            --this.moveLogOffset;
        }
    }

    public void increaseMoveLogOffset() {
        ++this.moveLogOffset;
    }

    public static void open(ChessTileEntity chessTileEntity) {
        Minecraft.m_91087_().m_91152_((Screen)new ChessBoardSettingsScreen(chessTileEntity));
    }
}

