/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.objects.blocks.ChessBlock;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerUseCustomPlate {
    private final BlockPos pos;

    public MessageServerUseCustomPlate(BlockPos pos) {
        this.pos = pos;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    public static MessageServerUseCustomPlate deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        return new MessageServerUseCustomPlate(pos);
    }

    public static void handle(MessageServerUseCustomPlate message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        Level level = player.m_9236_();
        BlockPos chessPos = message.pos;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                BlockEntity blockEntity;
                if (level != null && (blockEntity = level.m_7702_(chessPos)) instanceof ChessTileEntity) {
                    ChessTileEntity chessTileEntity = (ChessTileEntity)blockEntity;
                    if (chessTileEntity.getUseCustomPlate()) {
                        chessTileEntity.setUseCustomPlate(false);
                        level.m_46597_(message.pos, (BlockState)level.m_8055_(message.pos).m_61124_((Property)ChessBlock.SHOW_PLATE, (Comparable)Boolean.valueOf(true)));
                    } else {
                        chessTileEntity.setUseCustomPlate(true);
                        level.m_46597_(message.pos, (BlockState)level.m_8055_(message.pos).m_61124_((Property)ChessBlock.SHOW_PLATE, (Comparable)Boolean.valueOf(false)));
                    }
                    level.m_7260_(message.pos, level.m_8055_(chessPos), level.m_8055_(chessPos), 2);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

