/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.tile_entities.ChessTileEntity;
import andrews.table_top_craft.util.NetworkUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerSetPieceSet {
    private final BlockPos pos;
    private final int pieceSet;

    public MessageServerSetPieceSet(BlockPos pos, int pieceSet) {
        this.pos = pos;
        this.pieceSet = pieceSet;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.pieceSet);
    }

    public static MessageServerSetPieceSet deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int pieceSet = buf.readInt();
        return new MessageServerSetPieceSet(pos, pieceSet);
    }

    public static void handle(MessageServerSetPieceSet message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        Level level = player.m_9236_();
        BlockPos chessPos = message.pos;
        int pieceSet = message.pieceSet;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                BlockEntity blockEntity;
                if (level != null && (blockEntity = level.m_7702_(chessPos)) instanceof ChessTileEntity) {
                    ChessTileEntity chessTileEntity = (ChessTileEntity)blockEntity;
                    switch (pieceSet) {
                        case 0: {
                            chessTileEntity.setPieceSet(0);
                            break;
                        }
                        case 1: {
                            chessTileEntity.setPieceSet(1);
                            break;
                        }
                        case 2: {
                            chessTileEntity.setPieceSet(2);
                        }
                    }
                    level.m_7260_(message.pos, level.m_8055_(chessPos), level.m_8055_(chessPos), 2);
                    chessTileEntity.m_6596_();
                    NetworkUtil.setChessAnimationForAllTracking(level, chessPos, (byte)1);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

