/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.pieces;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.BoardUtils;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MajorAttackMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MajorMove;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;

public class BishopPiece
extends BasePiece {
    private static final int[] CANDIDATE_MOVE_VECTOR_COORDINATES = new int[]{-9, -7, 7, 9};

    public BishopPiece(PieceColor pieceColor, int piecePosition) {
        super(BasePiece.PieceType.BISHOP, piecePosition, pieceColor, true);
    }

    public BishopPiece(PieceColor pieceColor, int piecePosition, boolean isFirstMove) {
        super(BasePiece.PieceType.BISHOP, piecePosition, pieceColor, isFirstMove);
    }

    @Override
    public Collection<BaseMove> calculateLegalMoves(Board board) {
        ArrayList<BaseMove> legalMoves = new ArrayList<BaseMove>();
        block0: for (int candidateCoordinateOffset : CANDIDATE_MOVE_VECTOR_COORDINATES) {
            int candidateDestinationCoordinate = this.piecePosition;
            while (BoardUtils.isValidTileCoordinate(candidateDestinationCoordinate) && !BishopPiece.isFirstColumnExclusion(candidateDestinationCoordinate, candidateCoordinateOffset) && !BishopPiece.isEighthColumnExclusion(candidateDestinationCoordinate, candidateCoordinateOffset)) {
                if (!BoardUtils.isValidTileCoordinate(candidateDestinationCoordinate += candidateCoordinateOffset)) continue;
                BaseChessTile candidateDestinationTile = board.getTile(candidateDestinationCoordinate);
                if (!candidateDestinationTile.isTileOccupied()) {
                    legalMoves.add(new MajorMove(board, this, candidateDestinationCoordinate));
                    continue;
                }
                BasePiece pieceAtDestination = candidateDestinationTile.getPiece();
                PieceColor pieceColor = pieceAtDestination.getPieceColor();
                if (this.pieceColor == pieceColor) continue block0;
                legalMoves.add(new MajorAttackMove(board, this, candidateDestinationCoordinate, pieceAtDestination));
                continue block0;
            }
        }
        return ImmutableList.copyOf(legalMoves);
    }

    public String toString() {
        return BasePiece.PieceType.BISHOP.toString();
    }

    private static boolean isFirstColumnExclusion(int currentPosition, int candidateOffset) {
        return BoardUtils.FIRST_COLUMN[currentPosition] && (candidateOffset == -9 || candidateOffset == 7);
    }

    private static boolean isEighthColumnExclusion(int currentPosition, int candidateOffset) {
        return BoardUtils.EIGHTH_COLUMN[currentPosition] && (candidateOffset == -7 || candidateOffset == 9);
    }

    @Override
    public int locationBonus() {
        return this.pieceColor.bishopBonus(this.piecePosition);
    }

    @Override
    public BishopPiece movePiece(BaseMove move) {
        return new BishopPiece(move.getMovedPiece().getPieceColor(), move.getDestinationCoordinate(), false);
    }
}

