/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.utils;

import com.stal111.valhelsia_structures.core.config.ModConfig;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class StructureUtils {
    public static boolean isStructureInDistance(ChunkGenerator generator, RandomState randomState, long seed, ChunkPos pos, List<Holder<StructureSet>> structures) {
        if ((Integer)ModConfig.COMMON.minStructureDistance.get() == 0) {
            return false;
        }
        for (Holder<StructureSet> structure : structures) {
            if (!generator.m_223141_(structure, randomState, seed, pos.f_45578_, pos.f_45579_, ((Integer)ModConfig.COMMON.minStructureDistance.get()).intValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSurfaceFlat(Structure.GenerationContext context, int size) {
        ChunkPos pos = context.f_226628_();
        int[] cornerHeights = StructureUtils.getCornerHeights(context, pos.m_45604_(), size, pos.m_45605_(), size);
        int minHeight = Math.min(Math.min(cornerHeights[0], cornerHeights[1]), Math.min(cornerHeights[2], cornerHeights[3]));
        int maxHeight = Math.max(Math.max(cornerHeights[0], cornerHeights[1]), Math.max(cornerHeights[2], cornerHeights[3]));
        return Math.abs(maxHeight - minHeight) <= (Integer)ModConfig.COMMON.flatnessDelta.get();
    }

    public static int[] getCornerHeights(Structure.GenerationContext context, int middleBlockX, int xSize, int middleBlockZ, int zSize) {
        ChunkGenerator generator = context.f_226622_();
        LevelHeightAccessor heightAccessor = context.f_226629_();
        RandomState randomState = context.f_226624_();
        return new int[]{generator.m_223235_(middleBlockX, middleBlockZ, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState), generator.m_223235_(middleBlockX, middleBlockZ + zSize, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState), generator.m_223235_(middleBlockX + xSize, middleBlockZ, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState), generator.m_223235_(middleBlockX + xSize, middleBlockZ + zSize, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState)};
    }
}

