/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures.pools;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.valhelsia_structures.common.block.SpecialSpawnerBlock;
import com.stal111.valhelsia_structures.common.block.entity.SpecialSpawnerBlockEntity;
import com.stal111.valhelsia_structures.core.init.ModBlocks;
import com.stal111.valhelsia_structures.core.init.world.ModStructurePoolElementTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValhelsiaSinglePoolElement
extends SinglePoolElement {
    private static final Codec<Either<ResourceLocation, StructureTemplate>> TEMPLATE_CODEC = Codec.of(ValhelsiaSinglePoolElement::encodeTemplate, (Decoder)ResourceLocation.f_135803_.map(Either::left));
    public static final Codec<ValhelsiaSinglePoolElement> CODEC = RecordCodecBuilder.create(instance -> instance.group(ValhelsiaSinglePoolElement.valhelsiaTemplateCodec(), (App)ValhelsiaSinglePoolElement.m_210462_(), (App)ValhelsiaSinglePoolElement.m_210538_(), (App)TerrainAdjustment.f_226918_.optionalFieldOf("terrain_adjustment").forGetter(element -> Optional.ofNullable(element.terrainAdjustment))).apply((Applicative)instance, (either, processorListHolder, projection, terrainAdjustment) -> new ValhelsiaSinglePoolElement((Either<ResourceLocation, StructureTemplate>)either, (Holder<StructureProcessorList>)processorListHolder, (StructureTemplatePool.Projection)projection, terrainAdjustment.orElse(null))));
    private static final List<EntityType<?>> SPAWNER_ENTITY = List.of(EntityType.f_20501_, EntityType.f_20524_, EntityType.f_20479_);
    private final TerrainAdjustment terrainAdjustment;

    public ValhelsiaSinglePoolElement(Either<ResourceLocation, StructureTemplate> resourceLocation, Holder<StructureProcessorList> processors, StructureTemplatePool.Projection projection, @Nullable TerrainAdjustment terrainAdjustment) {
        super(resourceLocation, processors, projection);
        this.terrainAdjustment = terrainAdjustment;
    }

    private static <T> DataResult<T> encodeTemplate(Either<ResourceLocation, StructureTemplate> either, DynamicOps<T> dynamicOps, T t) {
        Optional optional = either.left();
        return optional.isEmpty() ? DataResult.error((String)"Can not serialize a runtime pool element") : ResourceLocation.f_135803_.encode((Object)((ResourceLocation)optional.get()), dynamicOps, t);
    }

    protected static <E extends ValhelsiaSinglePoolElement> RecordCodecBuilder<E, Either<ResourceLocation, StructureTemplate>> valhelsiaTemplateCodec() {
        return TEMPLATE_CODEC.fieldOf("location").forGetter(element -> element.f_210411_);
    }

    public boolean m_213695_(StructureTemplateManager templateManager, @NotNull WorldGenLevel level, @NotNull StructureManager structureManager, @NotNull ChunkGenerator generator, @NotNull BlockPos offset, @NotNull BlockPos pos, @NotNull Rotation rotation, @NotNull BoundingBox box, @NotNull RandomSource random, boolean keepJigsaws) {
        StructurePlaceSettings structureplacesettings;
        StructureTemplate structuretemplate = (StructureTemplate)this.f_210411_.map(arg_0 -> ((StructureTemplateManager)templateManager).m_230359_(arg_0), Function.identity());
        if (!structuretemplate.m_230328_((ServerLevelAccessor)level, offset, pos, structureplacesettings = this.m_207169_(rotation, box, keepJigsaws), random, 18)) {
            return false;
        }
        for (StructureTemplate.StructureBlockInfo info : structuretemplate.m_74603_(offset, this.m_207169_(rotation, box, keepJigsaws), Blocks.f_50677_)) {
            StructureMode mode = StructureMode.valueOf((String)info.f_74677_.m_128461_("mode"));
            if (mode != StructureMode.DATA) continue;
            this.m_227329_((LevelAccessor)level, info, info.f_74675_, rotation, random, box);
        }
        return true;
    }

    public void m_227329_(@NotNull LevelAccessor level, @NotNull StructureTemplate.StructureBlockInfo blockInfo, @NotNull BlockPos pos, @NotNull Rotation rotation, @NotNull RandomSource random, @NotNull BoundingBox box) {
        String data = blockInfo.f_74677_.m_128461_("metadata");
        if (data.startsWith("spawner:")) {
            level.m_7471_(pos, false);
            level.m_7731_(pos, Blocks.f_50085_.m_49966_(), 2);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SpawnerBlockEntity) {
                EntityType<?> entityType;
                SpawnerBlockEntity blockEntity2 = (SpawnerBlockEntity)blockEntity;
                switch (data) {
                    case "spawner:zombie_or_skeleton_or_spider": {
                        EntityType<?> entityType2 = SPAWNER_ENTITY.get(random.m_188503_(SPAWNER_ENTITY.size()));
                        break;
                    }
                    case "spawner:zombie": {
                        EntityType<?> entityType2 = EntityType.f_20501_;
                        break;
                    }
                    case "spawner:skeleton": {
                        EntityType<?> entityType2 = EntityType.f_20524_;
                        break;
                    }
                    case "spawner:spider": {
                        EntityType<?> entityType2 = EntityType.f_20479_;
                        break;
                    }
                    default: {
                        EntityType<?> entityType2 = entityType = null;
                    }
                }
                if (entityType != null) {
                    blockEntity2.m_59801_().m_45462_(entityType);
                }
            }
        } else if (data.startsWith("special_spawner:")) {
            level.m_7471_(pos, false);
            level.m_7731_(pos, ((SpecialSpawnerBlock)((Object)ModBlocks.SPECIAL_SPAWNER.get())).m_49966_(), 2);
            BlockEntity entityType = level.m_7702_(pos);
            if (entityType instanceof SpecialSpawnerBlockEntity) {
                SpecialSpawnerBlockEntity blockEntity = (SpecialSpawnerBlockEntity)entityType;
                switch (data) {
                    case "special_spawner:zombie_or_skeleton_or_spider": {
                        BlockEntity blockEntity3 = SPAWNER_ENTITY.get(random.m_188503_(SPAWNER_ENTITY.size()));
                        break;
                    }
                    case "special_spawner:drowned": {
                        BlockEntity blockEntity3 = EntityType.f_20562_;
                        break;
                    }
                    default: {
                        BlockEntity blockEntity3 = entityType = null;
                    }
                }
                if (entityType != null) {
                    blockEntity.getSpawner().setEntityId((EntityType<?>)entityType);
                }
            }
        } else if (data.equals("sculk_sensor")) {
            level.m_7471_(pos, false);
            level.m_7731_(pos, Blocks.f_152500_.m_49966_(), 2);
        } else if (data.equals("sculk_shrieker")) {
            level.m_7471_(pos, false);
            level.m_7731_(pos, (BlockState)Blocks.f_220858_.m_49966_().m_61124_((Property)BlockStateProperties.f_222997_, (Comparable)Boolean.valueOf(true)), 2);
        }
        super.m_227329_(level, blockInfo, pos, rotation, random, box);
    }

    @NotNull
    public List<StructureTemplate.StructureBlockInfo> m_227324_(StructureTemplateManager templateManager, @NotNull BlockPos pos, @NotNull Rotation rotation, boolean relativePosition) {
        StructureTemplate structuretemplate = (StructureTemplate)this.f_210411_.map(arg_0 -> ((StructureTemplateManager)templateManager).m_230359_(arg_0), Function.identity());
        ObjectArrayList structureBlockInfos = structuretemplate.m_230335_(pos, new StructurePlaceSettings().m_74379_(rotation), Blocks.f_50677_, relativePosition);
        ArrayList<StructureTemplate.StructureBlockInfo> markers = new ArrayList<StructureTemplate.StructureBlockInfo>();
        for (StructureTemplate.StructureBlockInfo info : structureBlockInfos) {
            StructureMode mode = StructureMode.valueOf((String)info.f_74677_.m_128461_("mode"));
            if (mode != StructureMode.DATA) continue;
            markers.add(info);
        }
        return markers;
    }

    @Nonnull
    protected StructurePlaceSettings m_207169_(@Nonnull Rotation rotation, @Nonnull BoundingBox box, boolean keepJigsawBlocks) {
        return super.m_207169_(rotation, box, keepJigsawBlocks).m_74397_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
    }

    public TerrainAdjustment getTerrainAdjustment() {
        return this.terrainAdjustment != null ? this.terrainAdjustment : TerrainAdjustment.NONE;
    }

    @NotNull
    public StructurePoolElementType<?> m_207234_() {
        return (StructurePoolElementType)ModStructurePoolElementTypes.VALHELSIA_SINGLE.get();
    }
}

