/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures.height;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.valhelsia_structures.common.world.structures.height.StructureHeightProvider;
import com.stal111.valhelsia_structures.common.world.structures.height.StructureHeightProviderType;
import com.stal111.valhelsia_structures.core.init.world.ModStructureHeightProviderTypes;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.structure.Structure;

public class BelowSurfaceHeightProvider
extends StructureHeightProvider {
    public static final Codec<BelowSurfaceHeightProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.f_158914_.fieldOf("min_inclusive").forGetter(provider -> provider.minInclusive)).apply((Applicative)instance, BelowSurfaceHeightProvider::new));
    private final VerticalAnchor minInclusive;

    public BelowSurfaceHeightProvider(VerticalAnchor minInclusive) {
        this.minInclusive = minInclusive;
    }

    @Override
    public OptionalInt sample(BlockPos pos, Structure.GenerationContext context, Heightmap.Types heightmapType) {
        int min = this.minY(pos, context, heightmapType);
        int max = this.maxY(pos, context, heightmapType);
        return OptionalInt.of(Mth.m_216287_((RandomSource)context.f_226626_(), (int)min, (int)max));
    }

    @Override
    public int minY(BlockPos pos, Structure.GenerationContext context, Heightmap.Types heightmapType) {
        return this.minInclusive.m_142322_(this.getWorldGenerationContext(context));
    }

    @Override
    public int maxY(BlockPos pos, Structure.GenerationContext context, Heightmap.Types heightmapType) {
        return Math.max(this.minY(pos, context, heightmapType), context.f_226622_().m_223235_(pos.m_123341_(), pos.m_123343_(), heightmapType, context.f_226629_(), context.f_226624_()) - 12);
    }

    @Override
    public StructureHeightProviderType<?> getType() {
        return (StructureHeightProviderType)ModStructureHeightProviderTypes.BELOW_SURFACE_HEIGHT.get();
    }

    protected VerticalAnchor getMinInclusive() {
        return this.minInclusive;
    }
}

