/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.block;

import com.mojang.datafixers.util.Pair;
import com.stal111.valhelsia_structures.common.block.DungeonDoorBlock;
import com.stal111.valhelsia_structures.common.block.properties.ModBlockStateProperties;
import com.stal111.valhelsia_structures.core.init.ModBlocks;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.common.helper.VoxelShapeHelper;

public class DungeonDoorLeafBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty MIRRORED = ModBlockStateProperties.MIRRORED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIRRORED_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    private final EnumMap<Direction, Pair<VoxelShape, VoxelShape>> shapesCache;

    public DungeonDoorLeafBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)MIRRORED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = this.buildShapes();
    }

    private EnumMap<Direction, Pair<VoxelShape, VoxelShape>> buildShapes() {
        EnumMap<Direction, Pair<VoxelShape, VoxelShape>> map = new EnumMap<Direction, Pair<VoxelShape, VoxelShape>>(Direction.class);
        VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)SHAPE).forEach((direction, voxelShape) -> map.put((Direction)direction, (Pair<VoxelShape, VoxelShape>)Pair.of((Object)voxelShape, (Object)VoxelShapeHelper.rotateShapeHorizontal((VoxelShape)MIRRORED_SHAPE, (Direction)direction))));
        return map;
    }

    @Nonnull
    public String m_7705_() {
        return ((DungeonDoorBlock)((Object)ModBlocks.DUNGEON_DOOR.get())).m_7705_();
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Pair<VoxelShape, VoxelShape> pair = this.shapesCache.get(state.m_61143_((Property)FACING));
        return (Boolean)state.m_61143_((Property)MIRRORED) != false ? (VoxelShape)pair.getSecond() : (VoxelShape)pair.getFirst();
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (!level.m_8055_(currentPos.m_121945_(Direction.m_122364_((double)((Direction)state.m_61143_((Property)FACING)).m_122435_()).m_122424_())).m_60713_((Block)ModBlocks.DUNGEON_DOOR.get())) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockPos offsetPos = pos.m_121945_(Direction.m_122364_((double)((Direction)state.m_61143_((Property)FACING)).m_122435_()).m_122424_());
        BlockState offsetState = world.m_8055_(offsetPos);
        offsetState.m_60734_().m_6227_(offsetState, world, offsetPos, player, hand, hit);
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockPos offsetPos = pos.m_121945_(Direction.m_122364_((double)((Direction)state.m_61143_((Property)FACING)).m_122435_()).m_122424_());
        BlockState offsetState = level.m_8055_(offsetPos);
        level.m_5898_(null, 2001, offsetPos, Block.m_49956_((BlockState)offsetState));
        level.m_7731_(offsetPos, (Boolean)offsetState.m_61143_((Property)WATERLOGGED) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), 35);
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public PushReaction m_5537_(@Nonnull BlockState state) {
        return PushReaction.BLOCK;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, MIRRORED, WATERLOGGED});
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

