/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.ICustomItemRendererProvider;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper;
import net.mehvahdjukaar.supplementaries.client.renderers.items.JarItemRenderer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModCreativeTabs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSoftFluids;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class JarItem
extends AbstractMobContainerItem
implements ICustomItemRendererProvider {
    private JarBlockTile dummyTile = null;

    public JarItem(Block blockIn, Item.Properties properties) {
        super(blockIn, properties, 0.625f, 0.875f, true);
    }

    @Override
    public boolean canItemCatch(Entity e) {
        LivingEntity le;
        EntityType type = e.m_6095_();
        if (CommonConfigs.Functional.JAR_AUTO_DETECT.get().booleanValue() && this.canFitEntity(e) && !(e instanceof Monster)) {
            return true;
        }
        return type.m_204039_(ModTags.JAR_CATCHABLE) || type.m_204039_(ModTags.JAR_BABY_CATCHABLE) && e instanceof LivingEntity && (le = (LivingEntity)e).m_6162_() || this.isBoat(e) || BucketHelper.isModdedFish(e);
    }

    @Override
    public void playReleaseSound(Level world, Vec3 v) {
        world.m_6263_(null, v.m_7096_(), v.m_7098_(), v.m_7094_(), SoundEvents.f_11752_, SoundSource.PLAYERS, 1.0f, 0.05f);
    }

    @Override
    public void playCatchSound(Player player) {
        player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public ItemStack saveEntityInItem(Entity entity, ItemStack currentStack, ItemStack bucket) {
        if (this.isBoat(entity)) {
            return new ItemStack((ItemLike)ModRegistry.JAR_BOAT.get());
        }
        return super.saveEntityInItem(entity, currentStack, bucket);
    }

    public boolean isBoat(Entity e) {
        return e instanceof Boat;
    }

    @Override
    public InteractionResult doInteract(ItemStack stack, Player player, Entity entity, InteractionHand hand) {
        if (!this.captureEnabled().booleanValue()) {
            return InteractionResult.PASS;
        }
        return super.doInteract(stack, player, entity, hand);
    }

    private Boolean captureEnabled() {
        return CommonConfigs.Functional.JAR_CAPTURE.get();
    }

    @Override
    public boolean blocksPlacement() {
        return this.captureEnabled();
    }

    @Override
    public void addPlacementTooltip(List<Component> tooltip) {
        if (this.captureEnabled().booleanValue()) {
            super.addPlacementTooltip(tooltip);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag compoundTag = stack.m_41737_("BlockEntityTag");
        if (compoundTag == null) {
            if (!ClientConfigs.General.TOOLTIP_HINTS.get().booleanValue() || !flagIn.m_7050_()) {
                return;
            }
            tooltip.add((Component)Component.m_237115_((String)"message.supplementaries.jar").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        } else {
            if (compoundTag.m_128425_("LootTable", 8)) {
                tooltip.add((Component)Component.m_237113_((String)"???????").m_130940_(ChatFormatting.GRAY));
            }
            if (compoundTag.m_128441_("FluidHolder")) {
                CompoundTag com = compoundTag.m_128469_("FluidHolder");
                SoftFluid s = SoftFluidRegistry.get((String)com.m_128461_("Fluid"));
                int count = com.m_128451_("Count");
                if (!s.isEmpty() && count > 0) {
                    String bottle;
                    CompoundTag nbt = null;
                    Object add = "";
                    if (com.m_128441_("NBT") && (nbt = com.m_128469_("NBT")).m_128441_("Bottle") && !(bottle = nbt.m_128461_("Bottle").toLowerCase(Locale.ROOT)).equals("regular")) {
                        add = "_" + bottle;
                    }
                    tooltip.add((Component)Component.m_237110_((String)"message.supplementaries.fluid_tooltip", (Object[])new Object[]{Component.m_237115_((String)(s.getTranslationKey() + (String)add)), count}).m_130940_(ChatFormatting.GRAY));
                    if (nbt != null) {
                        PotionNBTHelper.addPotionTooltip((CompoundTag)nbt, tooltip, (float)1.0f);
                        return;
                    }
                }
            }
            if (compoundTag.m_128425_("Items", 9)) {
                NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)compoundTag, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.m_41619_()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    MutableComponent iformattabletextcomponent = itemstack.m_41786_().m_6881_();
                    String s = iformattabletextcomponent.getString();
                    s = s.replace(" Bucket", "");
                    s = s.replace(" Bottle", "");
                    s = s.replace("Bucket of ", "");
                    MutableComponent str = Component.m_237113_((String)s);
                    str.m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_()));
                    tooltip.add((Component)str.m_130940_(ChatFormatting.GRAY));
                }
                if (j - i > 0) {
                    tooltip.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!CommonConfigs.General.JAR_TAB.get().booleanValue() || group != ModCreativeTabs.JAR_TAB) {
            super.m_6787_(group, items);
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        CompoundTag com;
        SoftFluid s;
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && tag.m_128441_("FluidHolder") && (s = SoftFluidRegistry.get((String)(com = tag.m_128469_("FluidHolder")).m_128461_("Fluid"))) == ModSoftFluids.DIRT.get()) {
            return Rarity.RARE;
        }
        return super.m_41460_(stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && entity instanceof Player) {
            Player player = (Player)entity;
            JarBlockTile temp = new JarBlockTile(entity.m_20097_(), ModRegistry.JAR.get().m_49966_());
            temp.m_142466_(tag);
            SoftFluidTank fh = temp.getSoftFluidTank();
            if (fh.containsFood() && fh.tryDrinkUpFluid(player, world)) {
                CompoundTag newTag = new CompoundTag();
                temp.m_183515_(newTag);
                stack.m_41700_("BlockEntityTag", (Tag)newTag);
                return stack;
            }
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerEntity, InteractionHand hand) {
        if (this.m_8105_(playerEntity.m_21120_(hand)) != 0) {
            return ItemUtils.m_150959_((Level)world, (Player)playerEntity, (InteractionHand)hand);
        }
        return super.m_7203_(world, playerEntity, hand);
    }

    public int m_8105_(ItemStack stack) {
        CompoundTag tag;
        if (CommonConfigs.Functional.JAR_ITEM_DRINK.get().booleanValue() && (tag = stack.m_41737_("BlockEntityTag")) != null) {
            if (this.dummyTile == null) {
                this.dummyTile = new JarBlockTile(BlockPos.f_121853_, ModRegistry.JAR.get().m_49966_());
            }
            this.dummyTile.m_142466_(tag);
            SoftFluidTank fh = this.dummyTile.getSoftFluidTank();
            FoodProvider provider = fh.getFluid().getFoodProvider();
            Item food = provider.getFood();
            return food.m_8105_(food.m_7968_()) / provider.getDivider();
        }
        return 0;
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (CommonConfigs.Functional.JAR_ITEM_DRINK.get().booleanValue()) {
            return UseAnim.DRINK;
        }
        return UseAnim.NONE;
    }

    @Override
    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult r;
        if (CompatHandler.QUARK && this == ModRegistry.JAR_ITEM.get() && (r = QuarkCompat.tryCaptureTater(this, context)).m_19077_()) {
            return r;
        }
        return super.m_6225_(context);
    }

    public Supplier<ItemStackRenderer> getRendererFactory() {
        return JarItemRenderer::new;
    }
}

