/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.IPistonMotionReact;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class FlintBlock
extends Block
implements IPistonMotionReact {
    public FlintBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onMoved(BlockState movedState, Level level, BlockPos pos, Direction direction, boolean extending, PistonMovingBlockEntity tile) {
        BlockPos firePos;
        if (!extending && !level.f_46443_ && level.m_8055_(firePos = pos.m_121945_(direction)).m_60795_()) {
            for (Direction ironDir : Direction.values()) {
                BlockPos ironPos;
                BlockState facingState;
                if (ironDir.m_122434_() == direction.m_122434_() || !FlintBlock.canBlockCreateSpark(facingState = level.m_8055_(ironPos = firePos.m_121945_(ironDir)), level, ironPos, ironDir.m_122424_())) continue;
                this.ignitePosition(level, firePos, false);
                return;
            }
        }
    }

    private void ignitePosition(Level level, BlockPos firePos, boolean isIronMoving) {
        NetworkHandler.CHANNEL.sendToAllClientPlayersInRange(level, firePos, 64.0, (Message)new ClientBoundParticlePacket(Vec3.m_82512_((Vec3i)firePos), ClientBoundParticlePacket.EventType.FLINT_BLOCK_IGNITE, isIronMoving ? 1 : 0));
        for (Direction dir : Direction.values()) {
            if (!BaseFireBlock.m_49255_((Level)level, (BlockPos)firePos, (Direction)dir)) continue;
            level.m_46597_(firePos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)firePos));
            level.m_142346_(null, GameEvent.f_157797_, firePos);
            break;
        }
        this.playSound(level, firePos);
    }

    public static boolean canBlockCreateSpark(BlockState state, Level level, BlockPos pos, Direction face) {
        return state.m_204336_(ModTags.FLINT_METALS) && state.m_60783_((BlockGetter)level, pos, face);
    }

    private void playSound(Level level, BlockPos pos) {
        RandomSource randomSource = level.m_213780_();
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, (randomSource.m_188501_() - randomSource.m_188501_()) * 0.2f + 1.0f);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block oldNeghbor, BlockPos targetPos, boolean isMoving) {
        super.m_6861_(state, level, pos, oldNeghbor, targetPos, isMoving);
        BlockState newState = level.m_8055_(targetPos);
        if (!newState.m_60795_() || !oldNeghbor.m_204297_().m_203656_(ModTags.FLINT_METALS)) {
            return;
        }
        Direction dir = Direction.m_175360_((BlockPos)pos.m_121996_((Vec3i)targetPos));
        for (Direction pistonDir : Direction.values()) {
            BlockState magnetState;
            if (dir.m_122434_() == pistonDir.m_122434_()) continue;
            BlockPos tilePos = targetPos.m_121945_(pistonDir);
            BlockEntity be = level.m_7702_(tilePos);
            if (be instanceof PistonMovingBlockEntity) {
                PistonMovingBlockEntity piston = (PistonMovingBlockEntity)be;
                if (piston.m_60392_() != pistonDir.m_122424_() || !piston.m_60400_().m_60713_(oldNeghbor) || !FlintBlock.canBlockCreateSpark(piston.m_60400_(), level, tilePos, dir)) continue;
                this.ignitePosition(level, targetPos, true);
                continue;
            }
            if (be == null || !CompatHandler.QUARK || (magnetState = QuarkCompat.getMagnetStateForFlintBlock(be, pistonDir)) == null || !magnetState.m_60713_(oldNeghbor) || !FlintBlock.canBlockCreateSpark(magnetState, level, tilePos, dir)) continue;
            this.ignitePosition(level, targetPos, true);
        }
    }
}

