/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.util;

import com.mojang.math.Vector3d;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;

public abstract class DirectionHelper {
    public static Rotation getRotation(Direction from, Direction toMatch) {
        if (from.equals((Object)Direction.UP) || from.equals((Object)Direction.DOWN) || toMatch.equals((Object)Direction.UP) || toMatch.equals((Object)Direction.DOWN)) {
            return Rotation.NONE;
        }
        Rotation r = Rotation.NONE;
        while (!r.m_55954_(toMatch).equals((Object)from.m_122424_())) {
            r = r.m_55952_(Rotation.CLOCKWISE_90);
        }
        return r;
    }

    public static Vec3i getOffsets(Rotation or, Rotation r, Direction d) {
        Vec3i newX = or.m_55954_(Direction.EAST).m_122436_();
        Vec3i newZ = or.m_55954_(Direction.SOUTH).m_122436_();
        switch (r) {
            case NONE: {
                return d.m_122436_().m_142393_(25);
            }
            case CLOCKWISE_90: {
                return newX.m_142393_(24).m_121955_(d.m_122436_().m_142393_(25));
            }
            case CLOCKWISE_180: {
                return newX.m_142393_(24).m_121955_(newZ.m_142393_(24)).m_121955_(d.m_122436_().m_142393_(25));
            }
            case COUNTERCLOCKWISE_90: {
                return newZ.m_142393_(24).m_121955_(d.m_122436_().m_142393_(25));
            }
        }
        return null;
    }

    public static Vec3i getRotatedVec(Vec3i toRotate, Rotation rotation) {
        Vec3i newX = rotation.m_55954_(Direction.EAST).m_122436_();
        Vec3i newZ = rotation.m_55954_(Direction.SOUTH).m_122436_();
        Vec3i newY = Direction.UP.m_122436_();
        newY = newY.m_142393_(toRotate.m_123342_());
        newX = newX.m_142393_(toRotate.m_123341_());
        newZ = newZ.m_142393_(toRotate.m_123343_());
        return newX.m_121955_(newY).m_121955_(newZ);
    }

    public static Vector3d getRotatedVec(Vector3d toRotate, Rotation rotation) {
        Vec3i newX = rotation.m_55954_(Direction.EAST).m_122436_();
        Vec3i newZ = rotation.m_55954_(Direction.SOUTH).m_122436_();
        Vec3i newY = Direction.UP.m_122436_();
        Vector3d newXD = new Vector3d((double)newX.m_123341_(), (double)newX.m_123342_(), (double)newX.m_123343_());
        Vector3d newYD = new Vector3d((double)newY.m_123341_(), (double)newY.m_123342_(), (double)newY.m_123343_());
        Vector3d newZD = new Vector3d((double)newZ.m_123341_(), (double)newZ.m_123342_(), (double)newZ.m_123343_());
        newYD.m_176283_(toRotate.f_86215_);
        newXD.m_176283_(toRotate.f_86214_);
        newZD.m_176283_(toRotate.f_86216_);
        Vector3d result = new Vector3d(0.0, 0.0, 0.0);
        result.m_176291_(newXD);
        result.m_176291_(newYD);
        result.m_176291_(newZD);
        return result;
    }

    public static AABB rotateAABBblockCenterRelated(AABB toRotate, Rotation r) {
        Vector3d firstCorner = new Vector3d(toRotate.f_82288_, toRotate.f_82289_, toRotate.f_82290_);
        Vector3d secondCorner = new Vector3d(toRotate.f_82291_, toRotate.f_82292_, toRotate.f_82293_);
        firstCorner.m_176283_(16.0);
        secondCorner.m_176283_(16.0);
        Vector3d inversMiddleShift = new Vector3d(-8.0, -8.0, -8.0);
        firstCorner.m_176291_(inversMiddleShift);
        secondCorner.m_176291_(inversMiddleShift);
        firstCorner = DirectionHelper.getRotatedVec(firstCorner, r);
        Vector3d middleShift = new Vector3d(8.0, 8.0, 8.0);
        firstCorner.m_176291_(middleShift);
        secondCorner = DirectionHelper.getRotatedVec(secondCorner, r);
        secondCorner.m_176291_(middleShift);
        firstCorner.m_176283_(0.0625);
        secondCorner.m_176283_(0.0625);
        AABB newAABB = new AABB(Math.min(firstCorner.f_86214_, secondCorner.f_86214_), Math.min(firstCorner.f_86215_, secondCorner.f_86215_), Math.min(firstCorner.f_86216_, secondCorner.f_86216_), Math.max(firstCorner.f_86214_, secondCorner.f_86214_), Math.max(firstCorner.f_86215_, secondCorner.f_86215_), Math.max(firstCorner.f_86216_, secondCorner.f_86216_));
        return newAABB;
    }

    public static int getRotationDegrees(Rotation r) {
        switch (r) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 90;
            }
            case CLOCKWISE_180: {
                return 180;
            }
            case COUNTERCLOCKWISE_90: {
                return 270;
            }
        }
        return 0;
    }

    public static Rotation getRotationNoOpp(Direction from, Direction toMatch) {
        if (from.equals((Object)Direction.UP) || from.equals((Object)Direction.DOWN) || toMatch.equals((Object)Direction.UP) || toMatch.equals((Object)Direction.DOWN)) {
            return Rotation.NONE;
        }
        Rotation r = Rotation.NONE;
        while (!r.m_55954_(from).equals((Object)toMatch)) {
            r = r.m_55952_(Rotation.CLOCKWISE_90);
        }
        return r;
    }
}

